/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import biz.netcentric.cq.tools.actool.history.impl.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidExternalGroupUsageValidationException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExternalGroupsInIsMemberOfValidator.class})
public class ExternalGroupsInIsMemberOfValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalGroupsInIsMemberOfValidator.class);

    public void validateIsMemberOfConfig(AcConfiguration acConfiguration, PersistableInstallationLogger installLog, GlobalConfiguration globalConfiguration) throws InvalidExternalGroupUsageValidationException {
        List<String> externalGroupsValidationResults = this.checkIsMemberOfConfigsOfAllAuthorizables(acConfiguration);
        if (!externalGroupsValidationResults.isEmpty()) {
            externalGroupsValidationResults.stream().forEach(m -> installLog.addWarning(LOG, (String)m));
            String validationMsg = "Found " + externalGroupsValidationResults.size() + " authorizable(s) that use external groups in isMemberOf. ";
            if (Boolean.TRUE.equals(globalConfiguration.getAllowExternalGroupsInIsMemberOf())) {
                installLog.addWarning(LOG, validationMsg);
                installLog.addWarning(LOG, "Found global config 'allowExternalGroupsInIsMemberOf: true': PLEASE REFACTOR your groups structure to not use external groups in isMemberOf.");
            } else {
                installLog.addError(LOG, validationMsg + " If absolutely needed, use 'allowExternalGroupsInIsMemberOf: true' in global configuration, but prefer to refactor your groups structure to not use isMemberOf together with external groups.", null);
                throw new InvalidExternalGroupUsageValidationException(validationMsg);
            }
        }
    }

    private List<String> checkIsMemberOfConfigsOfAllAuthorizables(AcConfiguration acConfiguration) {
        LinkedList<String> validationErrors = new LinkedList<String>();
        AuthorizablesConfig authorizablesConfig = acConfiguration.getAuthorizablesConfig();
        for (AuthorizableConfigBean authorizableConfigBean : authorizablesConfig) {
            List groupIdsWithExternalIdSet;
            if (authorizableConfigBean.getIsMemberOf() == null || (groupIdsWithExternalIdSet = Arrays.stream(authorizableConfigBean.getIsMemberOf()).map(aId -> acConfiguration.getAuthorizablesConfig().getAuthorizableConfig((String)aId)).filter(Objects::nonNull).filter(authBean -> StringUtils.isNotBlank((CharSequence)authBean.getExternalId())).map(AuthorizableConfigBean::getAuthorizableId).collect(Collectors.toList())).isEmpty()) continue;
            validationErrors.add("The authorizable " + authorizableConfigBean.getAuthorizableId() + " cannot use external group(s) in isMemberOf list: " + StringUtils.join(groupIdsWithExternalIdSet, (String)","));
        }
        return validationErrors;
    }
}

