/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.authorizableinstaller.impl;

import biz.netcentric.cq.tools.actool.authorizableinstaller.AuthorizableCreatorException;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExternalGroupInstallerServiceImpl.class})
public class ExternalGroupInstallerServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalGroupInstallerServiceImpl.class);

    public Authorizable createGroupWithExternalId(UserManager userManager, AuthorizableConfigBean authorizableConfigBean, InstallationLogger status, Session session) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        if (StringUtils.isBlank((CharSequence)authorizableConfigBean.getExternalId())) {
            throw new IllegalStateException("externalId must not be empty for " + authorizableConfigBean);
        }
        PrecreatedExternalGroup externalGroup = new PrecreatedExternalGroup(authorizableConfigBean);
        ExternalGroupPrecreatorSyncContext externalGroupPrecreatorSyncContext = new ExternalGroupPrecreatorSyncContext(userManager, session.getValueFactory());
        Group group = externalGroupPrecreatorSyncContext.createExternalGroup(externalGroup);
        return group;
    }

    private final class PrecreatedExternalGroup
    implements ExternalGroup {
        private final AuthorizableConfigBean authorizableConfigBean;

        private PrecreatedExternalGroup(AuthorizableConfigBean authorizableConfigBean) {
            this.authorizableConfigBean = authorizableConfigBean;
        }

        public String getId() {
            return this.authorizableConfigBean.getAuthorizableId();
        }

        public String getPrincipalName() {
            String principalName = ExternalIdentityRef.fromString((String)this.authorizableConfigBean.getExternalId()).getId();
            return principalName;
        }

        public String getIntermediatePath() {
            String rawIntermediatePath = this.authorizableConfigBean.getPath();
            String intermediatePath = StringUtils.removeStart((String)rawIntermediatePath, (String)"/home/groups/");
            return intermediatePath;
        }

        public ExternalIdentityRef getExternalId() {
            return ExternalIdentityRef.fromString((String)this.authorizableConfigBean.getExternalId());
        }

        public Map<String, ?> getProperties() {
            return Collections.emptyMap();
        }

        public Iterable<ExternalIdentityRef> getDeclaredGroups() throws ExternalIdentityException {
            return Collections.emptyList();
        }

        public Iterable<ExternalIdentityRef> getDeclaredMembers() throws ExternalIdentityException {
            return Collections.emptyList();
        }
    }

    private final class ExternalGroupPrecreatorSyncContext
    extends DefaultSyncContext {
        private ExternalGroupPrecreatorSyncContext(UserManager userManager, ValueFactory valueFactory) {
            super(new DefaultSyncConfig(), null, userManager, valueFactory);
        }

        private Group createExternalGroup(ExternalGroup eg) throws RepositoryException {
            this.config.group().setPathPrefix("");
            return this.createGroup(eg);
        }
    }
}

