/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.records.IteratorFormat;
import be.ugent.rml.records.Record;
import be.ugent.rml.records.XMLRecord;
import be.ugent.rml.records.xpath.SaxNamespaceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

public class XMLRecordFactory
extends IteratorFormat<XdmNode> {
    private Processor saxProcessor = new Processor(false);

    @Override
    List<Record> getRecordsFromDocument(XdmNode document, String iterator) throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        try {
            XPathCompiler compiler = this.saxProcessor.newXPathCompiler();
            compiler.setCaching(true);
            SaxNamespaceResolver.registerNamespaces(compiler, document);
            XdmValue result = compiler.evaluate(iterator, (XdmItem)document);
            result.forEach(item -> records.add(new XMLRecord((XdmItem)item, compiler)));
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return records;
    }

    @Override
    XdmNode getDocumentFromStream(InputStream stream) throws IOException {
        try {
            DocumentBuilder docBuilder = this.saxProcessor.newDocumentBuilder();
            return docBuilder.build((Source)new StreamSource(stream));
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
            return null;
        }
    }
}

