/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.records.IteratorFormat;
import be.ugent.rml.records.JSONRecord;
import be.ugent.rml.records.Record;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class JSONRecordFactory
extends IteratorFormat<Object> {
    @Override
    List<Record> getRecordsFromDocument(Object document, String iterator) {
        ArrayList<Record> records = new ArrayList<Record>();
        Configuration conf = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
        String escapedIterator = iterator.replaceAll(",", "\\\\,");
        try {
            List pathList = (List)JsonPath.using((Configuration)conf).parse(document).read(escapedIterator, new Predicate[0]);
            for (String p : pathList) {
                records.add(new JSONRecord(document, p));
            }
        }
        catch (JsonPathException e) {
            this.logger.warn("{} for iterator {}", new Object[]{e.getMessage(), iterator, e});
        }
        return records;
    }

    @Override
    Object getDocumentFromStream(InputStream stream) throws IOException {
        return Configuration.defaultConfiguration().jsonProvider().parse(stream, "utf-8");
    }

    @Override
    Object getDocumentFromStream(InputStream stream, String contentType) throws IOException {
        if (contentType.toLowerCase().equals("jsonl")) {
            JsonProvider provider = Configuration.defaultConfiguration().jsonProvider();
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(stream));
            Object items = provider.createArray();
            int index = 0;
            while (lineReader.ready()) {
                provider.setArrayIndex(items, index, provider.parse(lineReader.readLine()));
                ++index;
            }
            return items;
        }
        return this.getDocumentFromStream(stream);
    }
}

