/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import be.ugent.rml.records.CSVRecord;
import be.ugent.rml.records.CSVW;
import be.ugent.rml.records.ExcelRecord;
import be.ugent.rml.records.ODSRecord;
import be.ugent.rml.records.Record;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVRecordFactory
implements ReferenceFormulationRecordFactory {
    private static final Logger logger = LoggerFactory.getLogger(CSVRecordFactory.class);

    @Override
    public List<Record> getRecords(Access access, Term logicalSource, QuadStore rmlStore) throws Exception {
        List<Term> sources = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null));
        Term source = sources.get(0);
        if (source instanceof Literal) {
            String extension;
            String filePath = source.getValue();
            switch (extension = FilenameUtils.getExtension((String)filePath)) {
                case "xlsx": {
                    return this.getRecordsForExcel(access);
                }
                case "ods": {
                    return this.getRecordsForODT(access);
                }
            }
            return this.getRecordsForCSV(access, null);
        }
        List<Term> sourceType = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
        if (sourceType.get(0).getValue().equals("http://www.w3.org/ns/csvw#Table")) {
            CSVW csvw = new CSVW(rmlStore, logicalSource);
            return this.getRecordsForCSV(access, csvw);
        }
        return this.getRecordsForCSV(access, null);
    }

    private List<Record> getRecordsForExcel(Access access) throws IOException, SQLException, ClassNotFoundException {
        ArrayList<Record> output = new ArrayList<Record>();
        try (InputStream is = access.getInputStream();
             XSSFWorkbook workbook = new XSSFWorkbook(is);){
            for (Sheet datatypeSheet : workbook) {
                Row header = datatypeSheet.getRow(0);
                boolean first = true;
                for (Row currentRow : datatypeSheet) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    output.add(new ExcelRecord(header, currentRow));
                }
            }
        }
        return output;
    }

    private List<Record> getRecordsForODT(Access access) throws Exception {
        ArrayList<Record> output = new ArrayList<Record>();
        try (InputStream is = access.getInputStream();){
            SpreadsheetDocument document = SpreadsheetDocument.loadDocument((InputStream)is);
            for (Table table : document.getTableList()) {
                org.odftoolkit.simple.table.Row header = table.getRowByIndex(0);
                boolean first = true;
                for (org.odftoolkit.simple.table.Row currentRow : table.getRowList()) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    output.add(new ODSRecord(header, currentRow));
                }
            }
        }
        return output;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Record> getRecordsForCSV(Access access, CSVW csvw) throws IOException, SQLException, ClassNotFoundException {
        try {
            if (csvw == null) {
                try (BOMInputStream inputStream = new BOMInputStream(access.getInputStream());){
                    List<Record> list;
                    block14: {
                        CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).withSkipLines(0).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build();
                        try {
                            List records = reader.readAll();
                            String[] header = (String[])records.get(0);
                            list = records.subList(1, records.size()).stream().filter(r -> ((String[])r).length != 0 && (((String[])r).length != 1 || r[0] != null)).map(record -> new CSVRecord(header, (String[])record, access.getDataTypes())).collect(Collectors.toList());
                            if (reader == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    return list;
                }
            }
            return csvw.getRecords(access);
        }
        catch (CsvException | IllegalArgumentException e) {
            logger.debug("Could not parse CSV inputstream", e);
            return new ArrayList<Record>();
        }
    }
}

