/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SPARQLEndpointAccess
implements Access {
    private String contentType;
    private String endpoint;
    private String query;

    public SPARQLEndpointAccess(String contentType, String endpoint, String query) {
        this.contentType = contentType;
        this.endpoint = endpoint;
        this.query = query;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = new URL(this.endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", this.contentType);
        HashMap<String, String> urlParams = new HashMap<String, String>(){
            {
                this.put("query", SPARQLEndpointAccess.this.query);
            }
        };
        connection.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.writeBytes(Utils.getURLParamsString((Map<String, String>)urlParams));
        out.flush();
        out.close();
        int status = connection.getResponseCode();
        return connection.getInputStream();
    }

    public boolean equals(Object o) {
        if (o instanceof SPARQLEndpointAccess) {
            SPARQLEndpointAccess access = (SPARQLEndpointAccess)o;
            return this.endpoint.equals(access.getEndpoint()) && this.contentType.equals(access.getContentType()) && this.query.equals(access.getQuery());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getEndpoint() + this.getQuery() + this.getContentType());
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getQuery() {
        return this.query;
    }

    public static String cleanQuery(String query) {
        return query.replaceAll("[\r\n]+", " ").trim();
    }
}

