/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class RemoteFileAccess
implements Access {
    private String location;
    private String contentType;

    public RemoteFileAccess(String location) {
        this(location, "");
    }

    public RemoteFileAccess(String location, String contentType) {
        this.location = location;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Utils.getInputStreamFromURL(new URL(this.location), this.contentType);
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFileAccess) {
            RemoteFileAccess access = (RemoteFileAccess)o;
            return this.location.equals(access.getLocation()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getLocation() + this.getContentType());
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

