/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import be.ugent.rml.access.DatabaseType;
import com.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RDBAccess
implements Access {
    private String dsn;
    private DatabaseType databaseType;
    private String username;
    private String password;
    private String query;
    private String contentType;
    private Map<String, String> datatypes = new HashMap<String, String>();
    private static final String DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static final String VARBINARY = "http://www.w3.org/2001/XMLSchema#hexBinary";
    private static final String DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    private static final String INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String DATE = "http://www.w3.org/2001/XMLSchema#date";
    private static final String TIME = "http://www.w3.org/2001/XMLSchema#time";
    private static final String DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";

    public RDBAccess(String dsn, DatabaseType databaseType, String username, String password, String query, String contentType) {
        this.dsn = dsn;
        this.databaseType = databaseType;
        this.username = username;
        this.password = password;
        this.query = query;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException, ClassNotFoundException {
        InputStream inputStream;
        Connection connection = null;
        Statement statement = null;
        try {
            boolean alreadySomeQueryParametersPresent = this.dsn.contains("?");
            if (this.databaseType == DatabaseType.MYSQL) {
                StringBuilder parametersSB = new StringBuilder();
                if (alreadySomeQueryParametersPresent) {
                    parametersSB.append("&");
                } else {
                    parametersSB.append("?");
                }
                parametersSB.append("serverTimezone=UTC&useSSL=false");
                this.dsn = this.dsn + parametersSB;
            }
            if (this.databaseType == DatabaseType.SQL_SERVER) {
                this.dsn = this.dsn.replaceAll("[?&]", ";");
            }
            connection = DriverManager.getConnection(this.dsn, this.username, this.password);
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(this.query);
            inputStream = "http://semweb.mmlab.be/ns/ql#XPath".equals(this.contentType) ? this.getXMLInputStream(rs) : this.getCSVInputStream(rs);
            rs.close();
            statement.close();
            connection.close();
        }
        catch (Exception sqlE) {
            throw sqlE;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return inputStream;
    }

    @Override
    public Map<String, String> getDataTypes() {
        return this.datatypes;
    }

    private InputStream getCSVInputStream(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        boolean filledInDataTypes = false;
        StringWriter writer = new StringWriter();
        try {
            CSVWriter csvWriter = new CSVWriter((Writer)writer);
            csvWriter.writeNext(this.getCSVHeader(rsmd, columnCount));
            while (rs.next()) {
                String[] csvRow = new String[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    Object data;
                    String columnName = rsmd.getColumnLabel(i);
                    String dataType = this.getColumnDataType(rsmd.getColumnTypeName(i));
                    if (!filledInDataTypes && dataType != null) {
                        this.datatypes.put(columnName, dataType);
                    }
                    if (VARBINARY.equals(dataType)) {
                        data = rs.getBytes(columnName);
                        csvRow[i - 1] = RDBAccess.bytesToHexString(data);
                        continue;
                    }
                    data = rs.getString(columnName);
                    csvRow[i - 1] = RDBAccess.normalizeData((String)data, dataType);
                }
                csvWriter.writeNext(csvRow);
                filledInDataTypes = true;
            }
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    private InputStream getXMLInputStream(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        StringWriter writer = new StringWriter();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element rootElement = doc.createElement("Results");
            doc.appendChild(rootElement);
            while (rs.next()) {
                Element row = doc.createElement("row");
                rootElement.appendChild(row);
                for (int i = 1; i <= columnCount; ++i) {
                    Element el = doc.createElement(rsmd.getColumnName(i));
                    el.appendChild(doc.createTextNode(rs.getObject(i).toString()));
                    row.appendChild(el);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    private String getColumnDataType(String type) {
        switch (type.toUpperCase()) {
            case "BYTEA": 
            case "BINARY": 
            case "BINARY VARYING": 
            case "BINARY LARGE OBJECT": 
            case "VARBINARY": {
                return VARBINARY;
            }
            case "NUMERIC": 
            case "DECIMAL": {
                return DECIMAL;
            }
            case "SMALLINT": 
            case "INT": 
            case "INT4": 
            case "INT8": 
            case "INTEGER": 
            case "BIGINT": {
                return INTEGER;
            }
            case "FLOAT": 
            case "FLOAT4": 
            case "FLOAT8": 
            case "REAL": 
            case "DOUBLE": 
            case "DOUBLE PRECISION": {
                return DOUBLE;
            }
            case "BIT": 
            case "BOOL": 
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "DATE": {
                return DATE;
            }
            case "TIME": {
                return TIME;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return DATETIME;
            }
        }
        return null;
    }

    private String[] getCSVHeader(ResultSetMetaData rsmd, int columnCount) throws SQLException {
        String[] headers = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            headers[i - 1] = rsmd.getColumnLabel(i);
            if (headers[i - 1] != null && !headers[i - 1].equals("")) continue;
            headers[i - 1] = "be.ugent.rml.access.RDBAccess.nullheader";
        }
        return headers;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(String.format("%02X", b));
        }
        return builder.toString();
    }

    private static String normalizeData(String data, String dataType) {
        if (DOUBLE.equals(dataType) && data.endsWith(".0")) {
            return data.replace(".0", "");
        }
        return data;
    }

    public boolean equals(Object o) {
        if (o instanceof RDBAccess) {
            RDBAccess access = (RDBAccess)o;
            return this.dsn.equals(access.getDSN()) && this.databaseType.equals((Object)access.getDatabaseType()) && this.username.equals(access.getUsername()) && this.password.equals(access.getPassword()) && this.query.equals(access.getQuery()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getDSN() + this.getDatabaseType() + this.getUsername() + this.getPassword() + this.getQuery() + this.getContentType());
    }

    public String getDSN() {
        return this.dsn;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

