/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class LocalFileAccess
implements Access {
    private String path;
    private String basePath;

    public LocalFileAccess(String path, String basePath) {
        this.path = path;
        this.basePath = basePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        File file = new File(this.path);
        if (!file.isAbsolute()) {
            file = FileUtils.getFile((String[])new String[]{this.basePath, this.path});
        }
        return Utils.getInputStreamFromFile(file);
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof LocalFileAccess) {
            LocalFileAccess access = (LocalFileAccess)o;
            return this.path.equals(access.getPath()) && this.basePath.equals(access.getBasePath());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getPath() + this.getBasePath());
    }

    public String getPath() {
        return this.path;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public String getContentType() {
        return FilenameUtils.getExtension((String)this.path);
    }
}

