/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.rml.MappingInfo;
import be.ugent.rml.functions.MultipleRecordsFunctionExecutor;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.List;

public class PredicateObjectGraphMapping {
    private final MappingInfo predicateMappingInfo;
    private final MappingInfo objectMappingInfo;
    private final MappingInfo graphMappingInfo;
    private final MappingInfo languageMappingInfo;
    private final List<MultipleRecordsFunctionExecutor> joinConditions;
    private Term parentTriplesMap;

    public PredicateObjectGraphMapping(MappingInfo predicateMappingInfo, MappingInfo objectMappingInfo, MappingInfo graphMappingInfo, MappingInfo languageMappingInfo) {
        this.predicateMappingInfo = predicateMappingInfo;
        this.graphMappingInfo = graphMappingInfo;
        this.joinConditions = new ArrayList<MultipleRecordsFunctionExecutor>();
        this.objectMappingInfo = objectMappingInfo;
        this.languageMappingInfo = languageMappingInfo;
        if (this.languageMappingInfo != null) {
            this.objectMappingInfo.addTargets(this.languageMappingInfo.getTargets());
        }
    }

    public Term getParentTriplesMap() {
        return this.parentTriplesMap;
    }

    public List<MultipleRecordsFunctionExecutor> getJoinConditions() {
        return this.joinConditions;
    }

    public void setParentTriplesMap(Term parentTriplesMap) {
        this.parentTriplesMap = parentTriplesMap;
    }

    public void addJoinCondition(MultipleRecordsFunctionExecutor condition) {
        this.joinConditions.add(condition);
    }

    public MappingInfo getPredicateMappingInfo() {
        return this.predicateMappingInfo;
    }

    public MappingInfo getObjectMappingInfo() {
        return this.objectMappingInfo;
    }

    public MappingInfo getGraphMappingInfo() {
        return this.graphMappingInfo;
    }

    public MappingInfo getLanguageMappingInfo() {
        return this.languageMappingInfo;
    }
}

