/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.util;

import be.ugent.knows.util.SearchParameters;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache {
    private static final Map<String, List<String[]>> CACHE = new HashMap<String, List<String[]>>();
    private static final Map<SearchParameters, String> MULTIPLE_LOOKUP_STATE_MAP = new HashMap<SearchParameters, String>();
    private static final Logger logger = LoggerFactory.getLogger(Cache.class);

    public static Map<SearchParameters, String> getMultipleLookupStateMap() {
        return MULTIPLE_LOOKUP_STATE_MAP;
    }

    public static Map<SearchParameters, String> getCache() {
        return MULTIPLE_LOOKUP_STATE_MAP;
    }

    public static String fileToCache(List<String> searchValues, List<Integer> fromColumns, String inputFile, Integer toColumn, CSVReader reader) throws IOException, CsvValidationException {
        SearchParameters pair = new SearchParameters(searchValues, fromColumns, inputFile);
        if (reader != null) {
            String[] nextLine = reader.readNext();
            if (Cache.areParametersIncorrect(nextLine, toColumn, searchValues, fromColumns, inputFile)) {
                return null;
            }
            while (nextLine != null) {
                Cache.rowToCache(inputFile, nextLine);
                if (pair.getRowMatch() == null) {
                    pair.setRowMatch(Cache.check(fromColumns, searchValues, nextLine));
                }
                Cache.createExtraSearchParameters(searchValues, fromColumns, inputFile, toColumn, Arrays.asList(nextLine));
                nextLine = reader.readNext();
            }
            reader.close();
            if (pair.getRowMatch() != null) {
                MULTIPLE_LOOKUP_STATE_MAP.put(pair, pair.getRowMatch().get(toColumn));
            } else {
                logger.error("The searchString is not found; searchString: \"{}\", inputFile: \"{}\", fromColumns: \"{}\"", new Object[]{searchValues, inputFile, fromColumns});
                return null;
            }
        }
        return MULTIPLE_LOOKUP_STATE_MAP.get(pair);
    }

    public static String readFromCache(List<String> searchValues, List<Integer> fromColumns, String inputFile, Integer toColumn) {
        SearchParameters pair = new SearchParameters(searchValues, fromColumns, inputFile);
        String[] nextLine = CACHE.get(inputFile).get(0);
        if (Cache.areParametersIncorrect(nextLine, toColumn, searchValues, fromColumns, inputFile)) {
            return null;
        }
        List<String[]> table = CACHE.get(inputFile);
        for (String[] strings : table) {
            if (pair.getRowMatch() == null) {
                pair.setRowMatch(Cache.check(fromColumns, searchValues, strings));
            }
            Cache.createExtraSearchParameters(searchValues, fromColumns, inputFile, toColumn, Arrays.asList(strings));
        }
        if (pair.getRowMatch() == null) {
            logger.error("The searchString is not found; searchString: \"{}\", inputFile: \"{}\", fromColumns: \"{}\"", new Object[]{searchValues, inputFile, fromColumns});
            return null;
        }
        MULTIPLE_LOOKUP_STATE_MAP.put(pair, pair.getRowMatch().get(toColumn));
        return MULTIPLE_LOOKUP_STATE_MAP.get(pair);
    }

    private static void createExtraSearchParameters(List<String> searchValues, List<Integer> fromColumns, String inputFile, Integer toColumn, List<String> line) {
        List<String> values = fromColumns.stream().map(line::get).collect(Collectors.toList());
        SearchParameters extraPair = new SearchParameters(values, fromColumns, inputFile);
        extraPair.setRowMatch(line);
        if (!values.equals(searchValues) && !MULTIPLE_LOOKUP_STATE_MAP.containsKey(extraPair)) {
            MULTIPLE_LOOKUP_STATE_MAP.put(extraPair, extraPair.getRowMatch().get(toColumn));
        }
    }

    private static boolean areParametersIncorrect(String[] nextLine, Integer toColumn, List<String> searchValues, List<Integer> fromColumns, String inputFile) {
        if (toColumn == null || searchValues.isEmpty() || toColumn < 0 || toColumn >= nextLine.length || searchValues.size() != fromColumns.size()) {
            logger.error("Column index out of boundaries; inputFile: \"{}\", fromColumns: \"{}\", toColumn: \"{}\"", new Object[]{inputFile, fromColumns, toColumn});
            return true;
        }
        for (Integer index : fromColumns) {
            if (index >= 0 && index <= nextLine.length) continue;
            logger.error("Column index out of boundaries; inputFile: \"{}\", fromColumns: \"{}\", toColumn: \"{}\"", new Object[]{inputFile, fromColumns, toColumn});
            return true;
        }
        return false;
    }

    private static List<String> check(List<Integer> fromColumns, List<String> searchValues, String[] nextLine) {
        for (int i = 0; i < fromColumns.size(); ++i) {
            if (nextLine[fromColumns.get(i)].equals(searchValues.get(i))) continue;
            return null;
        }
        return Arrays.asList(nextLine);
    }

    public static void rowToCache(String inputFile, String[] row) {
        if (!CACHE.containsKey(inputFile)) {
            CACHE.put(inputFile, new ArrayList());
        }
        CACHE.get(inputFile).add(row);
    }
}

