/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import be.ugent.knows.idlabFunctions.state.MapState;
import be.ugent.knows.idlabFunctions.state.SimpleInMemoryMapState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInMemorySingleValueMapState<K, V>
implements MapState<V, K, V> {
    private static final Logger log = LoggerFactory.getLogger(SimpleInMemoryMapState.class);
    private final Map<String, Map<K, V>> stateFileToMap = new HashMap<String, Map<K, V>>();

    @Override
    public synchronized V put(String stateFilePath, K key, V value) {
        Map<K, V> map = this.computeMap(stateFilePath);
        return map.put(key, value);
    }

    @Override
    public synchronized Optional<Integer> putAndReturnIndex(String stateFilePath, K key, V value) {
        Map<K, V> map = this.computeMap(stateFilePath);
        if (map.containsKey(key)) {
            V knownValue = map.get(key);
            if (knownValue.equals(value)) {
                return Optional.empty();
            }
            map.put(key, value);
            return Optional.of(0);
        }
        map.put(key, value);
        return Optional.of(0);
    }

    @Override
    public synchronized Optional<Integer> replaceAndReturnIndex(String stateFilePath, K key, V value) {
        return this.putAndReturnIndex(stateFilePath, key, value);
    }

    @Override
    public void replace(String stateFilePath, K key, V value) {
        this.put(stateFilePath, key, value);
    }

    @Override
    public synchronized boolean hasKey(String stateFilePath, K key) {
        Map<K, V> map = this.computeMap(stateFilePath);
        return map.containsKey(key);
    }

    @Override
    public Map<K, V> getEntries(String stateFilePath) {
        return this.computeMap(stateFilePath);
    }

    @Override
    public synchronized void deleteAllState() {
        this.stateFileToMap.forEach((stateFilePath, stateMap) -> {
            File stateFile = new File((String)stateFilePath);
            if (!stateFile.delete()) {
                log.warn("Could not delete {}", stateFilePath);
            }
        });
        this.stateFileToMap.clear();
    }

    @Override
    public synchronized void saveAllState() {
        this.stateFileToMap.forEach((stateFilePath, stateMap) -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)stateFilePath, false)));){
                out.writeObject(stateMap);
            }
            catch (IOException e) {
                log.warn("Cannot save state map to {}", stateFilePath);
            }
        });
    }

    @Override
    public long count(String stateFilePath, K key) {
        Map<K, V> map = this.computeMap(stateFilePath);
        return map.containsKey(key) ? 1L : 0L;
    }

    @Override
    public synchronized void remove(String stateFilePath, K key) {
        Map<K, V> map = this.computeMap(stateFilePath);
        map.remove(key);
    }

    @Override
    public synchronized void close() throws Exception {
        this.saveAllState();
        this.stateFileToMap.clear();
    }

    private synchronized Map<K, V> computeMap(String stateFilePath) {
        return this.stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> {
            File stateFile = new File(stateFilePath);
            Map newMap = new HashMap();
            if (stateFile.exists() && stateFile.isFile() && stateFile.canRead()) {
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFilePath)));){
                    newMap = (Map)in.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    log.warn("Cannot load state map from file {}. Creating empty map!", (Object)stateFilePath);
                }
            }
            return newMap;
        });
    }
}

