/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.config;

import be.fluid_it.tools.dropwizard.box.config.ConfigurationBridge;
import be.fluid_it.tools.dropwizard.box.config.ConfigurationWriter;
import be.fluid_it.tools.dropwizard.box.config.ConfigurationWriterException;
import be.fluid_it.tools.dropwizard.box.config.ConfigurationWriterFactory;
import be.fluid_it.tools.dropwizard.box.config.ReflectionConfigurationWriterFactory;
import io.dropwizard.Configuration;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiConfigurationBridge<C extends Configuration>
implements ConfigurationBridge<C> {
    private Logger log = LoggerFactory.getLogger(JndiConfigurationBridge.class);
    private final ConfigurationWriterFactory writerFactory;
    private final String configurationContext;
    private static final String DEFAULT_CONTEXT = "java:comp/env/dropwizard/configuration";

    public JndiConfigurationBridge() {
        this(DEFAULT_CONTEXT);
    }

    public JndiConfigurationBridge(String configurationContext) {
        this(new ReflectionConfigurationWriterFactory(), configurationContext);
    }

    public JndiConfigurationBridge(ConfigurationWriterFactory writerFactory) {
        this(writerFactory, DEFAULT_CONTEXT);
    }

    public JndiConfigurationBridge(ConfigurationWriterFactory writerFactory, String configurationContext) {
        this.configurationContext = configurationContext;
        this.writerFactory = writerFactory;
    }

    @Override
    public void load(C configuration) {
        ConfigurationWriter configurationWriter = this.writerFactory.build(configuration);
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup(this.configurationContext);
            this.writeEnumeration(envCtx, configurationWriter, null);
        }
        catch (NamingException e) {
            this.log.error("Can't configure property from J2EE Context", (Throwable)e);
        }
    }

    private void writeEnumeration(Context parentContext, ConfigurationWriter configurationWriter, List<String> path) {
        try {
            NamingEnumeration<NameClassPair> list = parentContext.list("");
            while (list.hasMore()) {
                NameClassPair next = list.next();
                String name = next.getName();
                if (path == null) {
                    path = new ArrayList<String>();
                }
                path.add(name);
                try {
                    Object value = parentContext.lookup(name);
                    if (value instanceof Context) {
                        this.writeEnumeration((Context)value, configurationWriter, path);
                    } else {
                        configurationWriter.write(path.toArray(new String[path.size()]), value);
                    }
                }
                catch (NamingException e) {
                    this.log.error("Can't read property " + name + " from JNDI Naming Context " + this.configurationContext, (Throwable)e);
                }
                catch (ConfigurationWriterException e) {
                    this.log.error("Can't write property " + name + " to Dropwizard Configuration", (Throwable)e);
                }
                path.remove(path.size() - 1);
            }
        }
        catch (NamingException e) {
            this.log.error("Can't configure property from J2EE Context", (Throwable)e);
        }
    }
}

