/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box;

import be.fluid_it.tools.dropwizard.box.config.BridgedConfigurationFactoryFactory;
import be.fluid_it.tools.dropwizard.box.config.ClasspathConfigurationSourceProvider;
import be.fluid_it.tools.dropwizard.box.config.ConfigurationBridge;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.CheckCommand;
import io.dropwizard.cli.Cli;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.JarLocation;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.util.component.LifeCycle;

public abstract class WebApplication<C extends Configuration>
extends Application<C>
implements ServletContextListener {
    private static ServletContext theServletContext;
    private final Application<C> dropwizardApplication;
    private final String[] args;
    private Environment dropwizardEnvironment;
    private ConfigurationBridge configurationBridge;

    public static ServletContext servletContext() {
        return theServletContext;
    }

    public WebApplication(Application<C> dropwizardApplication, String configurationFileLocation) {
        this(dropwizardApplication, new String[]{"server", configurationFileLocation});
    }

    public WebApplication(Application<C> dropwizardApplication, String[] args) {
        this.dropwizardApplication = dropwizardApplication;
        this.args = args;
    }

    public void setConfigurationBridge(ConfigurationBridge configurationBridge) {
        this.configurationBridge = configurationBridge;
    }

    public ConfigurationBridge getConfigurationBridge() {
        return this.configurationBridge;
    }

    public void initialize(Bootstrap<C> bootstrap) {
        if (this.configurationBridge != null) {
            bootstrap.setConfigurationFactoryFactory(new BridgedConfigurationFactoryFactory(this.configurationBridge));
        }
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new ClasspathConfigurationSourceProvider());
        this.dropwizardApplication.initialize(bootstrap);
    }

    public String getName() {
        return this.dropwizardApplication.getName() + "-war";
    }

    public void run(C configuration, Environment environment) throws Exception {
        this.dropwizardEnvironment = environment;
        this.dropwizardApplication.run(configuration, environment);
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (theServletContext != null) {
            throw new IllegalStateException("Multple WebListeners extending WebApplication detected. Only one is allowed!");
        }
        theServletContext = sce.getServletContext();
        try {
            Bootstrap bootstrap = new Bootstrap((Application)this);
            bootstrap.addCommand((ConfiguredCommand)new ServerCommand((Application)this));
            bootstrap.addCommand((ConfiguredCommand)new CheckCommand((Application)this));
            this.initialize(bootstrap);
            bootstrap.registerMetrics();
            Cli cli = new Cli(new JarLocation(((Object)((Object)this)).getClass()), bootstrap, (OutputStream)System.out, (OutputStream)System.err);
            if (!cli.run(this.args)) {
                throw new RuntimeException("Initialization of Dropwizard failed ...");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization of Dropwizard failed ...", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.dropwizardEnvironment != null) {
            LifecycleEnvironment lifecycle = this.dropwizardEnvironment.lifecycle();
            if (lifecycle != null) {
                for (LifeCycle managed : lifecycle.getManagedObjects()) {
                    try {
                        managed.stop();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Shutdown of Dropwizard failed ...", e);
                    }
                }
            }
            this.dropwizardEnvironment = null;
        }
        theServletContext = null;
    }
}

