/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.MapSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.StructSerializer;
import aws.smithy.kotlin.runtime.serde.json.JsonFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriter;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriterKt;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\"\b\u0007\u0018\u0000 K2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001KB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001dH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020!H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J)\u0010'\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110)\u00a2\u0006\u0002\b*H\u0016J)\u0010+\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110)\u00a2\u0006\u0002\b*H\u0016J)\u0010,\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110)\u00a2\u0006\u0002\b*H\u0016J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010/J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u00100J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u00101J\u001a\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u00102J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u00103J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u00104J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u00105J\u001f\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u00106J\"\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010%H\u0016J\u001a\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0016J1\u00107\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\r2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110)\u00a2\u0006\u0002\b*H\u0016J1\u00109\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\r2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110)\u00a2\u0006\u0002\b*H\u0016J\b\u0010;\u001a\u00020\u0011H\u0016J\u0010\u0010<\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010?\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010B\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0010\u0010C\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0010\u0010E\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001dH\u0016J\u0010\u0010F\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010G\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010H\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010I\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0012\u0010J\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010%H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonSerializer;", "Laws/smithy/kotlin/runtime/serde/Serializer;", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "Laws/smithy/kotlin/runtime/serde/MapSerializer;", "Laws/smithy/kotlin/runtime/serde/StructSerializer;", "<init>", "()V", "jsonWriter", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamWriter;", "toByteArray", "", "beginStruct", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "beginList", "beginMap", "endStruct", "", "endList", "endMap", "field", "value", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "", "", "", "", "", "Laws/smithy/kotlin/runtime/content/BigInteger;", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "", "", "", "", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "Laws/smithy/kotlin/runtime/content/Document;", "nullField", "structField", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "listField", "mapField", "entry", "key", "(Ljava/lang/String;Ljava/lang/Integer;)V", "(Ljava/lang/String;Ljava/lang/Long;)V", "(Ljava/lang/String;Ljava/lang/Float;)V", "(Ljava/lang/String;Ljava/lang/Double;)V", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "(Ljava/lang/String;Ljava/lang/Byte;)V", "(Ljava/lang/String;Ljava/lang/Short;)V", "(Ljava/lang/String;Ljava/lang/Character;)V", "listEntry", "listDescriptor", "mapEntry", "mapDescriptor", "serializeNull", "serializeBoolean", "serializeByte", "serializeShort", "serializeChar", "serializeInt", "serializeLong", "serializeFloat", "serializeDouble", "serializeBigInteger", "serializeBigDecimal", "serializeString", "serializeSdkSerializable", "serializeInstant", "serializeByteArray", "serializeDocument", "Companion", "serde-json"})
@SourceDebugExtension(value={"SMAP\nJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializer.kt\naws/smithy/kotlin/runtime/serde/json/JsonSerializer\n+ 2 Serializer.kt\naws/smithy/kotlin/runtime/serde/SerializerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n504#2,4:333\n514#2,4:337\n524#2,4:341\n1863#3,2:345\n1863#3,2:347\n*S KotlinDebug\n*F\n+ 1 JsonSerializer.kt\naws/smithy/kotlin/runtime/serde/json/JsonSerializer\n*L\n142#1:333,4\n147#1:337,4\n152#1:341,4\n318#1:345,2\n323#1:347,2\n*E\n"})
public final class JsonSerializer
implements Serializer,
ListSerializer,
MapSerializer,
StructSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonStreamWriter jsonWriter = JsonStreamWriterKt.jsonStreamWriter$default(false, 1, null);
    @NotNull
    private static final Set<Double> doublesToStringify;
    @NotNull
    private static final Set<Float> floatsToStringify;

    @NotNull
    public byte[] toByteArray() {
        byte[] byArray = this.jsonWriter.getBytes();
        if (byArray == null) {
            throw new SerializationException("Serializer payload is empty");
        }
        return byArray;
    }

    @NotNull
    public StructSerializer beginStruct(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginObject();
        return this;
    }

    @NotNull
    public ListSerializer beginList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginArray();
        return this;
    }

    @NotNull
    public MapSerializer beginMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginObject();
        return this;
    }

    public void endStruct() {
        this.jsonWriter.endObject();
    }

    public void endList() {
        this.jsonWriter.endArray();
    }

    public void endMap() {
        this.jsonWriter.endObject();
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        value.serialize((Serializer)this);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeByteArray(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, int value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeInt(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, long value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeLong(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, float value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeFloat(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeString(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, double value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeDouble(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeBigInteger(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeBigDecimal(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, boolean value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeBoolean(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, byte value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeByte(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, short value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeShort(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, char value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeChar(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeInstant(value, format);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @Nullable Document value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeDocument(value);
    }

    public void nullField(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeNull();
    }

    public void structField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super StructSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeStruct$iv = this;
        boolean $i$f$serializeStruct = false;
        StructSerializer struct$iv = $this$serializeStruct$iv.beginStruct(descriptor);
        block.invoke((Object)struct$iv);
        struct$iv.endStruct();
    }

    public void listField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeList$iv = this;
        boolean $i$f$serializeList = false;
        ListSerializer list$iv = $this$serializeList$iv.beginList(descriptor);
        block.invoke((Object)list$iv);
        list$iv.endList();
    }

    public void mapField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeMap$iv = this;
        boolean $i$f$serializeMap = false;
        MapSerializer map$iv = $this$serializeMap$iv.beginMap(descriptor);
        block.invoke((Object)map$iv);
        map$iv.endMap();
    }

    public void entry(@NotNull String key, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Integer n = value;
        if (n != null) {
            this.serializeInt(n);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Long l = value;
        if (l != null) {
            this.serializeLong(l);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Float f = value;
        if (f != null) {
            this.serializeFloat(f.floatValue());
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        String string = value;
        if (string != null) {
            this.serializeString(string);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        SdkSerializable sdkSerializable = value;
        if (sdkSerializable != null) {
            sdkSerializable.serialize((Serializer)this);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Double d = value;
        if (d != null) {
            this.serializeDouble(d);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Boolean bl = value;
        if (bl != null) {
            this.serializeBoolean(bl);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Byte value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Byte by = value;
        if (by != null) {
            this.serializeByte(by);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Short value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Short s = value;
        if (s != null) {
            this.serializeShort(s);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Character value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        Character c = value;
        if (c != null) {
            this.serializeChar(c.charValue());
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.jsonWriter.writeName(key);
        Instant instant = value;
        if (instant != null) {
            this.serializeInstant(instant, format);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Document value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        this.serializeDocument(value);
    }

    public void entry(@NotNull String key, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.jsonWriter.writeName(key);
        if (value != null) {
            this.serializeByteArray(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void listEntry(@NotNull String key, @NotNull SdkFieldDescriptor listDescriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listDescriptor, (String)"listDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(key);
        this.beginList(listDescriptor);
        block.invoke((Object)this);
        this.endList();
    }

    public void mapEntry(@NotNull String key, @NotNull SdkFieldDescriptor mapDescriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(key);
        this.beginMap(mapDescriptor);
        block.invoke((Object)this);
        this.endMap();
    }

    public void serializeNull() {
        this.jsonWriter.writeNull();
    }

    public void serializeBoolean(boolean value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeByte(byte value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeShort(short value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeChar(char value) {
        this.jsonWriter.writeValue(String.valueOf(value));
    }

    public void serializeInt(int value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeLong(long value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeFloat(float value) {
        if (floatsToStringify.contains(Float.valueOf(value))) {
            this.jsonWriter.writeValue(String.valueOf(value));
        } else {
            this.jsonWriter.writeValue(value);
        }
    }

    public void serializeDouble(double value) {
        if (doublesToStringify.contains(value)) {
            this.jsonWriter.writeValue(String.valueOf(value));
        } else {
            this.jsonWriter.writeValue(value);
        }
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeValue(value);
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeValue(value);
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeValue(value);
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.serialize((Serializer)this);
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                this.jsonWriter.writeRawValue(value.format(format));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.jsonWriter.writeValue(value.format(format));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void serializeByteArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializeString(Base64Kt.encodeBase64String((byte[])value));
    }

    public void serializeDocument(@Nullable Document value) {
        Document document = value;
        if (document instanceof Document.Number) {
            this.jsonWriter.writeValue(((Document.Number)value).getValue());
        } else if (document instanceof Document.String) {
            this.jsonWriter.writeValue(((Document.String)value).getValue());
        } else if (document instanceof Document.Boolean) {
            this.jsonWriter.writeValue(((Document.Boolean)value).getValue());
        } else if (document == null) {
            this.jsonWriter.writeNull();
        } else if (document instanceof Document.List) {
            this.jsonWriter.beginArray();
            Iterable $this$forEach$iv = ((Document.List)value).getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Document p0 = (Document)element$iv;
                boolean $i$f$serializeDocument$stub_for_inlining = false;
                boolean bl = false;
                this.serializeDocument(p0);
            }
            this.jsonWriter.endArray();
        } else if (document instanceof Document.Map) {
            this.jsonWriter.beginObject();
            Iterable $this$forEach$iv = ((Document.Map)value).getValue().entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                this.jsonWriter.writeName((String)it.getKey());
                this.serializeDocument((Document)it.getValue());
            }
            this.jsonWriter.endObject();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static {
        Object[] objectArray = new Double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN};
        doublesToStringify = SetsKt.setOf((Object[])objectArray);
        objectArray = new Float[]{Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN)};
        floatsToStringify = SetsKt.setOf((Object[])objectArray);
    }

    @InternalApi
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonSerializer$Companion;", "", "<init>", "()V", "doublesToStringify", "", "", "floatsToStringify", "", "serde-json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            try {
                nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_FULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.RFC_5322.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

