/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannelKt;
import aws.smithy.kotlin.runtime.io.SdkSink;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.LogLevel;
import aws.smithy.kotlin.runtime.util.CoroutineUtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/StreamingRequestBody;", "Lokhttp3/RequestBody;", "body", "Laws/smithy/kotlin/runtime/http/HttpBody;", "callContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Laws/smithy/kotlin/runtime/http/HttpBody;Lkotlin/coroutines/CoroutineContext;)V", "contentType", "Lokhttp3/MediaType;", "contentLength", "", "isOneShot", "", "isDuplex", "writeTo", "", "sink", "Lokio/BufferedSink;", "doWriteTo", "transferBody", "(Lokio/BufferedSink;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nStreamingRequestBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingRequestBody.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/StreamingRequestBody\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n*L\n1#1,100:1\n1#2:101\n1#2:106\n220#3,3:102\n110#3:105\n111#3,2:107\n*S KotlinDebug\n*F\n+ 1 StreamingRequestBody.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/StreamingRequestBody\n*L\n47#1:106\n47#1:102,3\n47#1:105\n47#1:107,2\n*E\n"})
public final class StreamingRequestBody
extends RequestBody {
    @NotNull
    private final HttpBody body;
    @NotNull
    private final CoroutineContext callContext;

    public StreamingRequestBody(@NotNull HttpBody body, @NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this.body = body;
        this.callContext = callContext;
        if (!(this.body instanceof HttpBody.ChannelContent || this.body instanceof HttpBody.SourceContent)) {
            boolean bl = false;
            String string = "Invalid streaming body " + this.body;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public MediaType contentType() {
        return null;
    }

    public long contentLength() {
        Long l = this.body.getContentLength();
        return l != null ? l : -1L;
    }

    public boolean isOneShot() {
        return this.body.isOneShot();
    }

    public boolean isDuplex() {
        return this.body.isDuplex();
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            this.doWriteTo(sink);
        }
        catch (Exception ex) {
            Exception exception = ex;
            if (exception instanceof CancellationException) {
                void $this$log$iv$iv;
                void $this$trace_u24default$iv;
                CoroutineContext coroutineContext = this.callContext;
                Function0 content$iv = StreamingRequestBody::writeTo$lambda$1;
                Throwable ex$iv = null;
                boolean $i$f$trace = false;
                void var8_8 = $this$trace_u24default$iv;
                LogLevel level$iv$iv = LogLevel.Trace;
                boolean $i$f$log = false;
                String string = Reflection.getOrCreateKotlinClass(StreamingRequestBody.class).getQualifiedName();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "log<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                String sourceComponent$iv$iv = string;
                CoroutineContextLogExtKt.log((CoroutineContext)$this$log$iv$iv, (LogLevel)level$iv$iv, (String)sourceComponent$iv$iv, ex$iv, (Function0)content$iv);
                return;
            }
            if (exception instanceof IOException) {
                throw ex;
            }
            throw new IOException(ex);
        }
    }

    private final void doWriteTo(BufferedSink sink) {
        CoroutineContext context = this.callContext.plus((CoroutineContext)CoroutineUtilsKt.derivedName((CoroutineContext)this.callContext, (String)"send-request-body"));
        if (this.isDuplex()) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)context.plus((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sink, this, null){
                Object L$0;
                int label;
                final /* synthetic */ BufferedSink $sink;
                final /* synthetic */ StreamingRequestBody this$0;
                {
                    this.$sink = $sink;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = (Closeable)this.$sink;
                            var3_4 = this.this$0;
                            var4_5 = null;
                            it = (BufferedSink)var2_3;
                            $i$a$-use-StreamingRequestBody$doWriteTo$1$1 = false;
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = StreamingRequestBody.access$transferBody(var3_4, it, (Continuation)this);
                            ** if (v0 != var7_2) goto lbl17
lbl16:
                            // 1 sources

                            return var7_2;
lbl17:
                            // 1 sources

                            ** GOTO lbl26
                        }
                        case 1: {
                            $i$a$-use-StreamingRequestBody$doWriteTo$1$1 = false;
                            var4_5 = null;
                            var2_3 = (Closeable)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl26:
                                // 2 sources

                                var5_6 = Unit.INSTANCE;
                                ** GOTO lbl36
                            }
                            catch (Throwable var5_7) {
                                var4_5 = var5_7;
                                throw var5_7;
                            }
                        }
                        catch (Throwable var5_8) {
                            throw var5_8;
                        }
                        {
                            finally {
                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var4_5);
                            }
lbl36:
                            // 1 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            CoroutineContext blockingContext = context.minusKey((CoroutineContext.Key)CoroutineDispatcher.Key);
            BuildersKt.runBlocking((CoroutineContext)blockingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sink, null){
                int label;
                final /* synthetic */ StreamingRequestBody this$0;
                final /* synthetic */ BufferedSink $sink;
                {
                    this.this$0 = $receiver;
                    this.$sink = $sink;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = StreamingRequestBody.access$transferBody(this.this$0, this.$sink, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object transferBody(BufferedSink sink, Continuation<? super Unit> $completion) {
        HttpBody httpBody2 = this.body;
        if (httpBody2 instanceof HttpBody.ChannelContent) {
            SdkByteReadChannel chan = ((HttpBody.ChannelContent)this.body).readFrom();
            SdkSink sdkSink = ConvertKt.toSdk((Sink)((Sink)sink));
            Object object = SdkByteReadChannelKt.readAll((SdkByteReadChannel)chan, (SdkSink)sdkSink, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (httpBody2 instanceof HttpBody.SourceContent) {
            SdkSource source = ((HttpBody.SourceContent)this.body).readFrom();
            Closeable closeable = (Closeable)ConvertKt.toOkio((SdkSource)source);
            Throwable throwable = null;
            try {
                Source it = (Source)closeable;
                boolean bl = false;
                long l = sink.writeAll(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new IllegalStateException(("unexpected HttpBody type " + this.body).toString());
        }
        return Unit.INSTANCE;
    }

    private static final String writeTo$lambda$1() {
        return "request cancelled";
    }

    public static final /* synthetic */ Object access$transferBody(StreamingRequestBody $this, BufferedSink sink, Continuation $completion) {
        return $this.transferBody(sink, (Continuation<? super Unit>)$completion);
    }
}

