/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.Headers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010&\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016J \u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00110\u000fH\u0016J\u0011\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpHeadersAdapter;", "Laws/smithy/kotlin/runtime/http/Headers;", "headers", "Lokhttp3/Headers;", "<init>", "(Lokhttp3/Headers;)V", "caseInsensitiveName", "", "getCaseInsensitiveName", "()Z", "getAll", "", "", "name", "names", "", "entries", "", "contains", "isEmpty", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpHeadersAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpHeadersAdapter.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpHeadersAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class OkHttpHeadersAdapter
implements Headers {
    @NotNull
    private final okhttp3.Headers headers;
    private final boolean caseInsensitiveName;

    public OkHttpHeadersAdapter(@NotNull okhttp3.Headers headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.headers = headers;
        this.caseInsensitiveName = true;
    }

    public boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @Nullable
    public List<String> getAll(@NotNull String name) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection collection2 = this.headers.values(name);
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    @NotNull
    public Set<String> names() {
        return this.headers.names();
    }

    @NotNull
    public Set<Map.Entry<String, List<String>>> entries() {
        return this.headers.toMultimap().entrySet();
    }

    public boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.get(name) != null;
    }

    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    @Nullable
    public String get(@NotNull String name) {
        return Headers.DefaultImpls.get((Headers)this, (String)name);
    }

    public boolean contains(@NotNull String name, @NotNull String value) {
        return Headers.DefaultImpls.contains((Headers)this, (String)name, (String)value);
    }

    public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
        Headers.DefaultImpls.forEach((Headers)this, body);
    }
}

