/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.http.engine.okhttp.InstrumentedSink;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/InstrumentedRequestBody;", "Lokhttp3/RequestBody;", "delegate", "counter", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "<init>", "(Lokhttp3/RequestBody;Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;Laws/smithy/kotlin/runtime/collections/Attributes;)V", "contentType", "Lokhttp3/MediaType;", "isOneShot", "", "isDuplex", "contentLength", "", "writeTo", "", "sink", "Lokio/BufferedSink;", "http-client-engine-okhttp"})
public final class InstrumentedRequestBody
extends RequestBody {
    @NotNull
    private final RequestBody delegate;
    @NotNull
    private final MonotonicCounter counter;
    @NotNull
    private final Attributes attributes;

    public InstrumentedRequestBody(@NotNull RequestBody delegate, @NotNull MonotonicCounter counter, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.delegate = delegate;
        this.counter = counter;
        this.attributes = attributes;
    }

    @Nullable
    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public boolean isOneShot() {
        return this.delegate.isOneShot();
    }

    public boolean isDuplex() {
        return this.delegate.isDuplex();
    }

    public long contentLength() {
        return this.delegate.contentLength();
    }

    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        BufferedSink metricsSink = Okio.buffer((Sink)new InstrumentedSink(sink, this.counter, this.attributes));
        this.delegate.writeTo(metricsSink);
        if (metricsSink.isOpen()) {
            metricsSink.emit();
        }
    }
}

