/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.engine.EngineAttributes;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetrics;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpEngine;
import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.net.DefaultHostResolverJVMKt;
import aws.smithy.kotlin.runtime.net.HostResolver;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProviderContextKt;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import aws.smithy.kotlin.runtime.telemetry.logging.LoggerProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.Histogram;
import aws.smithy.kotlin.runtime.telemetry.metrics.HistogramKt;
import aws.smithy.kotlin.runtime.telemetry.trace.SpanStatus;
import aws.smithy.kotlin.runtime.telemetry.trace.TraceSpan;
import aws.smithy.kotlin.runtime.telemetry.trace.TraceSpanExtKt;
import aws.smithy.kotlin.runtime.telemetry.trace.Tracer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u001e\u001a\u00020\u001f2\u0012\b\u0004\u0010 \u001a\f\u0012\u0004\u0012\u00020\"0!j\u0002`#H\u0082\bJ%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0012\b\u0004\u0010 \u001a\f\u0012\u0004\u0012\u00020\"0!j\u0002`#H\u0082\bJ\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\"H\u0016J&\u0010)\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\"2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J&\u00100\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020+H\u0016J \u00103\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000202H\u0016J\u0010\u00107\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u00108\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J*\u0010;\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002022\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J2\u0010>\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002022\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010A\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010E\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010I\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010M\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010N\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010R\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020KH\u0016J\u0018\u0010S\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010T\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010U\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010V\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010W\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010X\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020PH\u0016J\u0018\u0010Y\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020PH\u0016J\u0018\u0010[\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010\\\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener;", "Lokhttp3/EventListener;", "pool", "Lokhttp3/ConnectionPool;", "hr", "Laws/smithy/kotlin/runtime/net/HostResolver;", "dispatcher", "Lokhttp3/Dispatcher;", "metrics", "Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "call", "Lokhttp3/Call;", "<init>", "(Lokhttp3/ConnectionPool;Laws/smithy/kotlin/runtime/net/HostResolver;Lokhttp3/Dispatcher;Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;Lokhttp3/Call;)V", "provider", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "traceSpan", "Laws/smithy/kotlin/runtime/telemetry/trace/TraceSpan;", "logger", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "callTimeStart", "Lkotlin/time/TimeMark;", "signaledQueuedDuration", "", "queuedDuration", "Lkotlin/time/Duration;", "J", "signaledConnectAcquireDuration", "dnsStartTime", "requestTimeEnd", "trace", "", "msg", "Lkotlin/Function0;", "", "Laws/smithy/kotlin/runtime/telemetry/logging/MessageSupplier;", "throwable", "", "callStart", "dnsStart", "domainName", "dnsEnd", "inetAddressList", "", "Ljava/net/InetAddress;", "proxySelectStart", "url", "Lokhttp3/HttpUrl;", "proxySelectEnd", "proxies", "Ljava/net/Proxy;", "connectStart", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "secureConnectStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "connectEnd", "protocol", "Lokhttp3/Protocol;", "connectFailed", "ioe", "Ljava/io/IOException;", "connectionAcquired", "connection", "Lokhttp3/Connection;", "requestHeadersStart", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestBodyStart", "requestBodyEnd", "byteCount", "", "requestFailed", "responseHeadersStart", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseBodyStart", "responseBodyEnd", "responseFailed", "connectionReleased", "callEnd", "callFailed", "canceled", "satisfactionFailure", "cacheConditionalHit", "cachedResponse", "cacheHit", "cacheMiss", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nHttpEngineEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpEngineEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LoggerProvider.kt\naws/smithy/kotlin/runtime/telemetry/logging/LoggerProviderKt\n*L\n1#1,219:1\n62#1,2:224\n62#1,2:226\n62#1,2:228\n62#1,2:230\n62#1,2:232\n62#1,2:234\n62#1,2:236\n62#1,2:238\n62#1,2:240\n66#1,2:242\n62#1,2:244\n62#1,2:246\n62#1,2:248\n62#1,2:250\n62#1,2:252\n66#1,2:254\n62#1,2:256\n62#1,2:258\n62#1,2:260\n62#1,2:262\n66#1,2:264\n62#1,2:266\n62#1,2:268\n66#1,2:270\n62#1,2:272\n62#1,2:274\n62#1,2:276\n62#1,2:278\n62#1,2:280\n258#2:220\n259#2:222\n1#3:221\n31#4:223\n*S KotlinDebug\n*F\n+ 1 HttpEngineEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener\n*L\n76#1:224,2\n86#1:226,2\n90#1:228,2\n92#1:230,2\n95#1:232,2\n98#1:234,2\n100#1:236,2\n102#1:238,2\n105#1:240,2\n114#1:242,2\n141#1:244,2\n144#1:246,2\n151#1:248,2\n154#1:250,2\n158#1:252,2\n161#1:254,2\n168#1:256,2\n173#1:258,2\n176#1:260,2\n179#1:262,2\n181#1:264,2\n187#1:266,2\n193#1:268,2\n200#1:270,2\n206#1:272,2\n211#1:274,2\n213#1:276,2\n215#1:278,2\n217#1:280,2\n48#1:220\n48#1:222\n48#1:221\n48#1:223\n*E\n"})
public final class HttpEngineEventListener
extends EventListener {
    @NotNull
    private final ConnectionPool pool;
    @NotNull
    private final HostResolver hr;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final HttpClientMetrics metrics;
    @NotNull
    private final TelemetryProvider provider;
    @NotNull
    private final TraceSpan traceSpan;
    @NotNull
    private final Logger logger;
    @Nullable
    private TimeMark callTimeStart;
    private boolean signaledQueuedDuration;
    private long queuedDuration;
    private boolean signaledConnectAcquireDuration;
    @Nullable
    private TimeMark dnsStartTime;
    @Nullable
    private TimeMark requestTimeEnd;

    public HttpEngineEventListener(@NotNull ConnectionPool pool, @NotNull HostResolver hr, @NotNull Dispatcher dispatcher, @NotNull HttpClientMetrics metrics, @NotNull Call call) {
        SdkRequestTag sdkRequestTag;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
                Intrinsics.checkNotNullParameter((Object)hr, (String)"hr");
                Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
                Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.pool = pool;
                this.hr = hr;
                this.dispatcher = dispatcher;
                this.metrics = metrics;
                SdkRequestTag sdkRequestTag2 = (SdkRequestTag)call.request().tag(SdkRequestTag.class);
                if (sdkRequestTag2 == null || (sdkRequestTag2 = sdkRequestTag2.getCallContext()) == null || (sdkRequestTag2 = TelemetryProviderContextKt.getTelemetryProvider((CoroutineContext)sdkRequestTag2)) == null) {
                    sdkRequestTag2 = TelemetryProvider.Companion.getNone();
                }
                this.provider = sdkRequestTag2;
                this.traceSpan = Tracer.DefaultImpls.createSpan$default((Tracer)this.provider.getTracerProvider().getOrCreateTracer("aws.smithy.kotlin.runtime.http.engine.okhttp"), (String)"HTTP", null, null, null, (int)14, null);
                sdkRequestTag = (SdkRequestTag)call.request().tag(SdkRequestTag.class);
                if (sdkRequestTag == null || (sdkRequestTag = sdkRequestTag.getCallContext()) == null) break block6;
                SdkRequestTag $this$logger$iv = sdkRequestTag;
                boolean $i$f$logger = false;
                String string = Reflection.getOrCreateKotlinClass(OkHttpEngine.class).getQualifiedName();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "logger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                String sourceComponent$iv = string;
                sdkRequestTag = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                if (sdkRequestTag != null) break block7;
            }
            LoggerProvider $this$getLogger$iv = LoggerProvider.Companion.getNone();
            boolean $i$f$getLogger = false;
            LoggerProvider loggerProvider = $this$getLogger$iv;
            String string = Reflection.getOrCreateKotlinClass(OkHttpEngine.class).getQualifiedName();
            if (string == null) {
                LoggerProvider loggerProvider2 = loggerProvider;
                boolean bl = false;
                LoggerProvider loggerProvider3 = loggerProvider2;
                String string3 = "getLogger<T> cannot be used on an anonymous object";
                throw new IllegalArgumentException(string3.toString());
            }
            sdkRequestTag = loggerProvider.getOrCreateLogger(string);
        }
        this.logger = sdkRequestTag;
        this.queuedDuration = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
    }

    private final void trace(Function0<String> msg) {
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(msg){
            final /* synthetic */ Function0<String> $msg;
            {
                this.$msg = $msg;
            }

            public final String invoke() {
                return (String)this.$msg.invoke();
            }
        }), (int)1, null);
    }

    private final void trace(Throwable throwable, Function0<String> msg) {
        boolean $i$f$trace = false;
        this.logger.trace(throwable, (Function0)new Function0<String>(msg){
            final /* synthetic */ Function0<String> $msg;
            {
                this.$msg = $msg;
            }

            public final String invoke() {
                return (String)this.$msg.invoke();
            }
        });
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        long now = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.callTimeStart = TimeSource.Monotonic.ValueTimeMark.box-impl((long)now);
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "call started";
            }
        }), (int)1, null);
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        this.dnsStartTime = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        if (!this.signaledQueuedDuration) {
            TimeMark timeMark = this.callTimeStart;
            if (timeMark == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            this.queuedDuration = timeMark.elapsedNow-UwyO8pc();
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getRequestsQueuedDuration(), (long)this.queuedDuration, null, null, (int)6, null);
            this.signaledQueuedDuration = true;
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(domainName){
            final /* synthetic */ String $domainName$inlined;
            {
                this.$domainName$inlined = string;
            }

            public final String invoke() {
                boolean bl = false;
                return "dns query: domain=" + this.$domainName$inlined;
            }
        }), (int)1, null);
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(domainName, inetAddressList){
            final /* synthetic */ String $domainName$inlined;
            final /* synthetic */ List $inetAddressList$inlined;
            {
                this.$domainName$inlined = string;
                this.$inetAddressList$inlined = list;
            }

            public final String invoke() {
                boolean bl = false;
                return "dns resolved: domain=" + this.$domainName$inlined + "; records=" + this.$inetAddressList$inlined;
            }
        }), (int)1, null);
    }

    public void proxySelectStart(@NotNull Call call, @NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(url){
            final /* synthetic */ HttpUrl $url$inlined;
            {
                this.$url$inlined = httpUrl;
            }

            public final String invoke() {
                boolean bl = false;
                return "proxy select start: url=" + this.$url$inlined;
            }
        }), (int)1, null);
    }

    public void proxySelectEnd(@NotNull Call call, @NotNull HttpUrl url, @NotNull List<? extends Proxy> proxies) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(proxies, (String)"proxies");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(url, proxies){
            final /* synthetic */ HttpUrl $url$inlined;
            final /* synthetic */ List $proxies$inlined;
            {
                this.$url$inlined = httpUrl;
                this.$proxies$inlined = list;
            }

            public final String invoke() {
                boolean bl = false;
                return "proxy select end: url=" + this.$url$inlined + "; proxies=" + this.$proxies$inlined;
            }
        }), (int)1, null);
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(inetSocketAddress, proxy){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
            }

            public final String invoke() {
                boolean bl = false;
                return "starting connection: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined;
            }
        }), (int)1, null);
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "initiating TLS connection";
            }
        }), (int)1, null);
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(handshake){
            final /* synthetic */ Handshake $handshake$inlined;
            {
                this.$handshake$inlined = handshake;
            }

            public final String invoke() {
                boolean bl = false;
                return "TLS connect end: handshake=" + this.$handshake$inlined;
            }
        }), (int)1, null);
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
            }

            public final String invoke() {
                boolean bl = false;
                return "connection established: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        }), (int)1, null);
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
            }

            public final String invoke() {
                boolean bl = false;
                return "connect failed: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        });
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
        this.hr.reportFailure(DefaultHostResolverJVMKt.toHostAddress((InetAddress)inetAddress));
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.metrics.setAcquiredConnections((long)this.pool.connectionCount());
        this.metrics.setIdleConnections((long)this.pool.idleConnectionCount());
        TimeMark timeMark = this.callTimeStart;
        if (timeMark == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        TimeMark callStarted = timeMark;
        if (!this.signaledQueuedDuration) {
            this.signaledQueuedDuration = true;
            this.queuedDuration = callStarted.elapsedNow-UwyO8pc();
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getRequestsQueuedDuration(), (long)this.queuedDuration, null, null, (int)6, null);
        }
        if (!this.signaledConnectAcquireDuration) {
            long l;
            this.signaledConnectAcquireDuration = true;
            if (this.dnsStartTime != null) {
                TimeMark timeMark2 = this.dnsStartTime;
                Intrinsics.checkNotNull((Object)timeMark2);
                l = timeMark2.elapsedNow-UwyO8pc();
            } else {
                l = Duration.minus-LRDsOJo((long)callStarted.elapsedNow-UwyO8pc(), (long)this.queuedDuration);
            }
            long connectAcquireDuration = l;
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getConnectionAcquireDuration(), (long)connectAcquireDuration, null, null, (int)6, null);
        }
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
            }

            public final String invoke() {
                boolean bl = false;
                return "connection acquired: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        }), (int)1, null);
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "sending request headers";
            }
        }), (int)1, null);
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() == null) {
            this.requestTimeEnd = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "finished sending request headers";
            }
        }), (int)1, null);
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "sending request body";
            }
        }), (int)1, null);
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.requestTimeEnd = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
            }

            public final String invoke() {
                boolean bl = false;
                return "finished sending request body: bytesSent=" + this.$byteCount$inlined;
            }
        }), (int)1, null);
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "request failed";
            }
        });
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        TimeMark timeMark = this.requestTimeEnd;
        if (timeMark != null) {
            long ttfb = timeMark.elapsedNow-UwyO8pc();
            boolean bl = false;
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getTimeToFirstByteDuration(), (long)ttfb, null, null, (int)6, null);
            SdkRequestTag sdkRequestTag = (SdkRequestTag)call.request().tag(SdkRequestTag.class);
            if (sdkRequestTag != null && (sdkRequestTag = sdkRequestTag.getExecContext()) != null) {
                sdkRequestTag.set(EngineAttributes.INSTANCE.getTimeToFirstByte(), Duration.box-impl((long)ttfb));
            }
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "response headers start";
            }
        }), (int)1, null);
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseBody responseBody = response.body();
        Long contentLength = responseBody != null ? Long.valueOf(responseBody.contentLength()) : null;
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(contentLength){
            final /* synthetic */ Long $contentLength$inlined;
            {
                this.$contentLength$inlined = l;
            }

            public final String invoke() {
                boolean bl = false;
                return "response headers end: contentLengthHeader=" + this.$contentLength$inlined;
            }
        }), (int)1, null);
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "response body available";
            }
        }), (int)1, null);
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
            }

            public final String invoke() {
                boolean bl = false;
                return "response body finished: bytesConsumed=" + this.$byteCount$inlined;
            }
        }), (int)1, null);
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "response failed";
            }
        });
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.metrics.setAcquiredConnections((long)this.pool.connectionCount());
        this.metrics.setIdleConnections((long)this.pool.idleConnectionCount());
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
            }

            public final String invoke() {
                boolean bl = false;
                return "connection released: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        }), (int)1, null);
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "call complete";
            }
        }), (int)1, null);
        this.traceSpan.close();
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "call failed";
            }
        });
        TraceSpanExtKt.recordException((TraceSpan)this.traceSpan, (Throwable)ioe, (boolean)true);
        this.traceSpan.setStatus(SpanStatus.ERROR);
        this.traceSpan.close();
    }

    public void canceled(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "call cancelled";
            }
        }), (int)1, null);
    }

    public void satisfactionFailure(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "cache satisfaction failure";
            }
        }), (int)1, null);
    }

    public void cacheConditionalHit(@NotNull Call call, @NotNull Response cachedResponse) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "cache conditional hit";
            }
        }), (int)1, null);
    }

    public void cacheHit(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "cache hit";
            }
        }), (int)1, null);
    }

    public void cacheMiss(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            public final String invoke() {
                boolean bl = false;
                return "cache miss";
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ ConnectionPool access$getPool$p(HttpEngineEventListener $this) {
        return $this.pool;
    }
}

