/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.serde;

import aws.sdk.kotlin.services.s3.model.ExpirationStatus;
import aws.sdk.kotlin.services.s3.model.LifecycleRule;
import aws.sdk.kotlin.services.s3.model.NoncurrentVersionTransition;
import aws.sdk.kotlin.services.s3.model.Transition;
import aws.sdk.kotlin.services.s3.serde.AbortIncompleteMultipartUploadDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.LifecycleExpirationDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.LifecycleRuleFilterDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.NoncurrentVersionExpirationDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.NoncurrentVersionTransitionDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.TransitionDocumentDeserializerKt;
import aws.smithy.kotlin.runtime.collections.CollectionExtKt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"deserializeLifecycleRuleDocument", "Laws/sdk/kotlin/services/s3/model/LifecycleRule;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlTagReader;", "s3"})
@SourceDebugExtension(value={"SMAP\nLifecycleRuleDocumentDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleRuleDocumentDeserializer.kt\naws/sdk/kotlin/services/s3/serde/LifecycleRuleDocumentDeserializerKt\n+ 2 Exceptions.kt\naws/smithy/kotlin/runtime/serde/ExceptionsKt\n+ 3 ResultExt.kt\naws/smithy/kotlin/runtime/util/ResultExtKt\n+ 4 Parsers.kt\naws/smithy/kotlin/runtime/serde/ParsersKt\n*L\n1#1,54:1\n45#2:55\n46#2:60\n45#2:61\n46#2:66\n45#2:68\n46#2:73\n15#3,4:56\n15#3,4:62\n15#3,4:69\n58#4:67\n*S KotlinDebug\n*F\n+ 1 LifecycleRuleDocumentDeserializer.kt\naws/sdk/kotlin/services/s3/serde/LifecycleRuleDocumentDeserializerKt\n*L\n23#1:55\n23#1:60\n26#1:61\n26#1:66\n32#1:68\n32#1:73\n23#1:56,4\n26#1:62,4\n32#1:69,4\n31#1:67\n*E\n"})
public final class LifecycleRuleDocumentDeserializerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LifecycleRule deserializeLifecycleRuleDocument(@NotNull XmlTagReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        LifecycleRule.Builder builder = new LifecycleRule.Builder();
        while (reader.nextTag() != null) {
            XmlTagReader curr;
            switch (curr.getTagName()) {
                case "Expiration": {
                    builder.setExpiration(LifecycleExpirationDocumentDeserializerKt.deserializeLifecycleExpirationDocument(curr));
                    break;
                }
                case "ID": {
                    LifecycleRule.Builder builder2;
                    boolean bl;
                    Object object;
                    void $this$getOrDeserializeErr$iv;
                    LifecycleRule.Builder builder3 = builder;
                    Object object2 = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    boolean $i$f$getOrDeserializeErr = false;
                    Object $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder3;
                        boolean bl2 = false;
                        builder3 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (string: `com.amazonaws.s3#ID`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    $this$mapErr$iv$iv = object;
                    ResultKt.throwOnFailure((Object)$this$mapErr$iv$iv);
                    builder3.setId((String)$this$mapErr$iv$iv);
                    break;
                }
                case "Prefix": {
                    Object object;
                    LifecycleRule.Builder builder2;
                    boolean bl;
                    LifecycleRule.Builder builder4 = builder;
                    Object $this$getOrDeserializeErr$iv = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    boolean $i$f$getOrDeserializeErr = false;
                    Object $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder4;
                        boolean bl3 = false;
                        builder4 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (string: `com.amazonaws.s3#Prefix`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    $this$mapErr$iv$iv = object;
                    ResultKt.throwOnFailure((Object)$this$mapErr$iv$iv);
                    builder4.setPrefix((String)$this$mapErr$iv$iv);
                    break;
                }
                case "Filter": {
                    builder.setFilter(LifecycleRuleFilterDocumentDeserializerKt.deserializeLifecycleRuleFilterDocument(curr));
                    break;
                }
                case "Status": {
                    Object object;
                    Object object3;
                    Object $this$parse$iv;
                    boolean bl;
                    Object $this$getOrDeserializeErr$iv = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    LifecycleRule.Builder builder2 = builder;
                    boolean $i$f$parse = false;
                    Object $this$mapErr$iv$iv = $this$parse$iv;
                    if (Result.isSuccess-impl((Object)$this$mapErr$iv$iv)) {
                        Object it;
                        Object $i$f$mapErr = $this$mapErr$iv$iv;
                        try {
                            it = (String)$i$f$mapErr;
                            boolean bl4 = false;
                            it = Result.constructor-impl((Object)ExpirationStatus.Companion.fromValue((String)it));
                        }
                        catch (Throwable bl4) {
                            it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                        }
                        object3 = it;
                    } else {
                        object3 = Result.constructor-impl((Object)$this$mapErr$iv$iv);
                    }
                    LifecycleRule.Builder builder5 = builder2;
                    $this$parse$iv = object3;
                    boolean $i$f$getOrDeserializeErr = false;
                    $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder5;
                        boolean bl5 = false;
                        builder5 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (enum: `com.amazonaws.s3#ExpirationStatus`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    Object object4 = object;
                    ResultKt.throwOnFailure((Object)object4);
                    builder5.setStatus((ExpirationStatus)object4);
                    break;
                }
                case "Transition": {
                    LifecycleRule.Builder builder2 = builder;
                    boolean bl = false;
                    Transition el = TransitionDocumentDeserializerKt.deserializeTransitionDocument(curr);
                    builder2.setTransitions(CollectionExtKt.createOrAppend(builder.getTransitions(), (Object)el));
                    break;
                }
                case "NoncurrentVersionTransition": {
                    LifecycleRule.Builder builder2 = builder;
                    boolean bl = false;
                    NoncurrentVersionTransition el = NoncurrentVersionTransitionDocumentDeserializerKt.deserializeNoncurrentVersionTransitionDocument(curr);
                    builder2.setNoncurrentVersionTransitions(CollectionExtKt.createOrAppend(builder.getNoncurrentVersionTransitions(), (Object)el));
                    break;
                }
                case "NoncurrentVersionExpiration": {
                    builder.setNoncurrentVersionExpiration(NoncurrentVersionExpirationDocumentDeserializerKt.deserializeNoncurrentVersionExpirationDocument(curr));
                    break;
                }
                case "AbortIncompleteMultipartUpload": {
                    builder.setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadDocumentDeserializerKt.deserializeAbortIncompleteMultipartUploadDocument(curr));
                }
            }
            curr.drop();
        }
        builder.correctErrors$s3();
        return builder.build();
    }
}

