/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.serde;

import aws.sdk.kotlin.services.s3.model.HeadObjectRequest;
import aws.smithy.kotlin.runtime.collections.MutableMultiMap;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpMethod;
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Laws/sdk/kotlin/services/s3/serde/HeadObjectOperationSerializer;", "Laws/smithy/kotlin/runtime/http/operation/HttpSerializer$NonStreaming;", "Laws/sdk/kotlin/services/s3/model/HeadObjectRequest;", "<init>", "()V", "serialize", "Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "input", "s3"})
@SourceDebugExtension(value={"SMAP\nHeadObjectOperationSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadObjectOperationSerializer.kt\naws/sdk/kotlin/services/s3/serde/HeadObjectOperationSerializer\n+ 2 HttpRequestBuilder.kt\naws/smithy/kotlin/runtime/http/request/HttpRequestBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n71#2:60\n72#2:62\n85#2,2:63\n1#3:61\n1628#4,3:65\n*S KotlinDebug\n*F\n+ 1 HeadObjectOperationSerializer.kt\naws/sdk/kotlin/services/s3/serde/HeadObjectOperationSerializer\n*L\n25#1:60\n25#1:62\n42#1:63,2\n28#1:65,3\n*E\n"})
public final class HeadObjectOperationSerializer
implements HttpSerializer.NonStreaming<HeadObjectRequest> {
    @NotNull
    public HttpRequestBuilder serialize(@NotNull ExecutionContext context, @NotNull HeadObjectRequest input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setMethod(HttpMethod.HEAD);
        HttpRequestBuilder $this$url$iv = builder;
        boolean $i$f$url = false;
        Url.Builder $this$serialize_u24lambda_u244 = $this$url$iv.getUrl();
        boolean bl = false;
        if (input.getKey() == null) {
            boolean bl2 = false;
            String string = "key is bound to the URI and must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        $this$serialize_u24lambda_u244.getPath().encodedSegments(arg_0 -> HeadObjectOperationSerializer.serialize$lambda$4$lambda$2(input, arg_0));
        $this$serialize_u24lambda_u244.getParameters().decodedParameters(PercentEncoding.Companion.getSmithyLabel(), arg_0 -> HeadObjectOperationSerializer.serialize$lambda$4$lambda$3(input, arg_0));
        HttpRequestBuilder $this$headers$iv = builder;
        boolean $i$f$headers = false;
        HeadersBuilder $this$serialize_u24lambda_u245 = $this$headers$iv.getHeaders();
        boolean bl3 = false;
        if (input.getChecksumMode() != null) {
            $this$serialize_u24lambda_u245.append("x-amz-checksum-mode", (Object)input.getChecksumMode().getValue());
        }
        String string = input.getExpectedBucketOwner();
        boolean bl4 = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl4) {
            $this$serialize_u24lambda_u245.append("x-amz-expected-bucket-owner", (Object)input.getExpectedBucketOwner());
        }
        String string2 = input.getIfMatch();
        boolean bl5 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
        if (bl5) {
            $this$serialize_u24lambda_u245.append("If-Match", (Object)input.getIfMatch());
        }
        if (input.getIfModifiedSince() != null) {
            $this$serialize_u24lambda_u245.append("If-Modified-Since", (Object)input.getIfModifiedSince().format(TimestampFormat.RFC_5322));
        }
        String string3 = input.getIfNoneMatch();
        boolean bl6 = string3 != null ? ((CharSequence)string3).length() > 0 : false;
        if (bl6) {
            $this$serialize_u24lambda_u245.append("If-None-Match", (Object)input.getIfNoneMatch());
        }
        if (input.getIfUnmodifiedSince() != null) {
            $this$serialize_u24lambda_u245.append("If-Unmodified-Since", (Object)input.getIfUnmodifiedSince().format(TimestampFormat.RFC_5322));
        }
        String string4 = input.getRange();
        boolean bl7 = string4 != null ? ((CharSequence)string4).length() > 0 : false;
        if (bl7) {
            $this$serialize_u24lambda_u245.append("Range", (Object)input.getRange());
        }
        if (input.getRequestPayer() != null) {
            $this$serialize_u24lambda_u245.append("x-amz-request-payer", (Object)input.getRequestPayer().getValue());
        }
        String string5 = input.getSseCustomerAlgorithm();
        boolean bl8 = string5 != null ? ((CharSequence)string5).length() > 0 : false;
        if (bl8) {
            $this$serialize_u24lambda_u245.append("x-amz-server-side-encryption-customer-algorithm", (Object)input.getSseCustomerAlgorithm());
        }
        String string6 = input.getSseCustomerKey();
        boolean bl9 = string6 != null ? ((CharSequence)string6).length() > 0 : false;
        if (bl9) {
            $this$serialize_u24lambda_u245.append("x-amz-server-side-encryption-customer-key", (Object)input.getSseCustomerKey());
        }
        String string7 = input.getSseCustomerKeyMd5();
        boolean bl10 = string7 != null ? ((CharSequence)string7).length() > 0 : false;
        if (bl10) {
            $this$serialize_u24lambda_u245.append("x-amz-server-side-encryption-customer-key-MD5", (Object)input.getSseCustomerKeyMd5());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit serialize$lambda$4$lambda$2(HeadObjectRequest $input, List $this$encodedSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$encodedSegments, (String)"$this$encodedSegments");
        String[] stringArray = new String[]{"/"};
        Iterable $this$mapTo$iv = StringsKt.split$default((CharSequence)$input.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = $this$encodedSegments;
            boolean bl = false;
            collection.add(PercentEncoding.Companion.getSmithyLabel().encode((String)it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit serialize$lambda$4$lambda$3(HeadObjectRequest $input, MutableMultiMap $this$decodedParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$decodedParameters, (String)"$this$decodedParameters");
        if ($input.getPartNumber() != null) {
            $this$decodedParameters.add((Object)"partNumber", (Object)$input.getPartNumber().toString());
        }
        if ($input.getResponseCacheControl() != null) {
            $this$decodedParameters.add((Object)"response-cache-control", (Object)$input.getResponseCacheControl());
        }
        if ($input.getResponseContentDisposition() != null) {
            $this$decodedParameters.add((Object)"response-content-disposition", (Object)$input.getResponseContentDisposition());
        }
        if ($input.getResponseContentEncoding() != null) {
            $this$decodedParameters.add((Object)"response-content-encoding", (Object)$input.getResponseContentEncoding());
        }
        if ($input.getResponseContentLanguage() != null) {
            $this$decodedParameters.add((Object)"response-content-language", (Object)$input.getResponseContentLanguage());
        }
        if ($input.getResponseContentType() != null) {
            $this$decodedParameters.add((Object)"response-content-type", (Object)$input.getResponseContentType());
        }
        if ($input.getResponseExpires() != null) {
            $this$decodedParameters.add((Object)"response-expires", (Object)$input.getResponseExpires().format(TimestampFormat.RFC_5322));
        }
        if ($input.getVersionId() != null) {
            $this$decodedParameters.add((Object)"versionId", (Object)$input.getVersionId());
        }
        return Unit.INSTANCE;
    }
}

