/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.serde;

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails;
import aws.sdk.kotlin.services.s3.internal.S3ErrorMetadataKt;
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse;
import aws.sdk.kotlin.services.s3.model.S3Exception;
import aws.sdk.kotlin.services.s3.model.StorageClass;
import aws.sdk.kotlin.services.s3.serde.ChecksumDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.GetObjectAttributesPartsDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.NoSuchKeyDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.ParsersKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwGetObjectAttributesError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeGetObjectAttributesOperationBody", "", "builder", "Laws/sdk/kotlin/services/s3/model/GetObjectAttributesResponse$Builder;", "s3"})
@SourceDebugExtension(value={"SMAP\nGetObjectAttributesOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetObjectAttributesOperationDeserializer.kt\naws/sdk/kotlin/services/s3/serde/GetObjectAttributesOperationDeserializerKt\n+ 2 Exceptions.kt\naws/smithy/kotlin/runtime/serde/ExceptionsKt\n+ 3 ResultExt.kt\naws/smithy/kotlin/runtime/util/ResultExtKt\n+ 4 Parsers.kt\naws/smithy/kotlin/runtime/serde/ParsersKt\n*L\n1#1,109:1\n45#2:110\n46#2:115\n45#2:116\n46#2:121\n45#2:123\n46#2:128\n15#3,4:111\n15#3,4:117\n15#3,4:124\n58#4:122\n*S KotlinDebug\n*F\n+ 1 GetObjectAttributesOperationDeserializer.kt\naws/sdk/kotlin/services/s3/serde/GetObjectAttributesOperationDeserializerKt\n*L\n93#1:110\n93#1:115\n99#1:116\n99#1:121\n103#1:123\n103#1:128\n93#1:111,4\n99#1:117,4\n103#1:124,4\n102#1:122\n*E\n"})
public final class GetObjectAttributesOperationDeserializerKt {
    private static final Void throwGetObjectAttributesError(ExecutionContext context, HttpCall call, byte[] payload) {
        S3ErrorDetails s3ErrorDetails;
        HttpResponse wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        HttpCall wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            s3ErrorDetails = payload == null ? (Intrinsics.areEqual((Object)call.getResponse().getStatus(), (Object)HttpStatusCode.Companion.getNotFound()) ? new S3ErrorDetails("NotFound", null, null, null, 14, null) : new S3ErrorDetails(call.getResponse().getStatus().toString(), null, null, null, 14, null)) : S3ErrorMetadataKt.parseS3ErrorResponse(payload);
        }
        catch (Exception ex) {
            S3Exception s3Exception;
            S3Exception it = s3Exception = new S3Exception("Failed to parse response as restXml error");
            boolean bl = false;
            S3ErrorMetadataKt.setS3ErrorMetadata((Object)it, wrappedCall.getResponse(), null);
            throw (Throwable)((Object)s3Exception);
        }
        S3ErrorDetails errorDetails = s3ErrorDetails;
        S3Exception ex = Intrinsics.areEqual((Object)errorDetails.getCode(), (Object)"NoSuchKey") ? (S3Exception)new NoSuchKeyDeserializer().deserialize(context, wrappedCall, payload) : new S3Exception(errorDetails.getMessage());
        S3ErrorMetadataKt.setS3ErrorMetadata((Object)ex, wrappedResponse, errorDetails);
        throw ex;
    }

    private static final void deserializeGetObjectAttributesOperationBody(GetObjectAttributesResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        while (root.nextTag() != null) {
            XmlTagReader curr;
            switch (curr.getTagName()) {
                case "Checksum": {
                    builder.setChecksum(ChecksumDocumentDeserializerKt.deserializeChecksumDocument(curr));
                    break;
                }
                case "ETag": {
                    GetObjectAttributesResponse.Builder builder2;
                    boolean bl;
                    Object object;
                    Object $this$getOrDeserializeErr$iv;
                    GetObjectAttributesResponse.Builder builder3 = builder;
                    Object object2 = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    boolean $i$f$getOrDeserializeErr = false;
                    Object $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder3;
                        boolean bl2 = false;
                        builder3 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (string: `com.amazonaws.s3#ETag`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    $this$mapErr$iv$iv = object;
                    ResultKt.throwOnFailure((Object)$this$mapErr$iv$iv);
                    builder3.setETag((String)$this$mapErr$iv$iv);
                    break;
                }
                case "ObjectParts": {
                    builder.setObjectParts(GetObjectAttributesPartsDocumentDeserializerKt.deserializeGetObjectAttributesPartsDocument(curr));
                    break;
                }
                case "ObjectSize": {
                    Object object;
                    GetObjectAttributesResponse.Builder builder2;
                    boolean bl;
                    GetObjectAttributesResponse.Builder builder4 = builder;
                    Object $this$getOrDeserializeErr$iv = ParsersKt.parseLong((Object)XmlTagReaderKt.tryData((XmlTagReader)curr));
                    boolean $i$f$getOrDeserializeErr = false;
                    Object $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder4;
                        boolean bl3 = false;
                        builder4 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (long: `com.amazonaws.s3#ObjectSize`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    $this$mapErr$iv$iv = object;
                    ResultKt.throwOnFailure((Object)$this$mapErr$iv$iv);
                    builder4.setObjectSize((Long)$this$mapErr$iv$iv);
                    break;
                }
                case "StorageClass": {
                    Object object;
                    Object object3;
                    Object $this$parse$iv;
                    boolean bl;
                    Object $this$getOrDeserializeErr$iv = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    GetObjectAttributesResponse.Builder builder2 = builder;
                    boolean $i$f$parse = false;
                    Object $this$mapErr$iv$iv = $this$parse$iv;
                    if (Result.isSuccess-impl((Object)$this$mapErr$iv$iv)) {
                        Object it;
                        Object $i$f$mapErr = $this$mapErr$iv$iv;
                        try {
                            it = (String)$i$f$mapErr;
                            boolean bl4 = false;
                            it = Result.constructor-impl((Object)StorageClass.Companion.fromValue((String)it));
                        }
                        catch (Throwable bl4) {
                            it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                        }
                        object3 = it;
                    } else {
                        object3 = Result.constructor-impl((Object)$this$mapErr$iv$iv);
                    }
                    GetObjectAttributesResponse.Builder builder5 = builder2;
                    $this$parse$iv = object3;
                    boolean $i$f$getOrDeserializeErr = false;
                    $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder5;
                        boolean bl5 = false;
                        builder5 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (enum: `com.amazonaws.s3#StorageClass`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    Object object4 = object;
                    ResultKt.throwOnFailure((Object)object4);
                    builder5.setStorageClass((StorageClass)object4);
                }
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwGetObjectAttributesError(ExecutionContext context, HttpCall call, byte[] payload) {
        return GetObjectAttributesOperationDeserializerKt.throwGetObjectAttributesError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeGetObjectAttributesOperationBody(GetObjectAttributesResponse.Builder builder, byte[] payload) {
        GetObjectAttributesOperationDeserializerKt.deserializeGetObjectAttributesOperationBody(builder, payload);
    }
}

