// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UploadPartCopyOperationSerializer: HttpSerializer.NonStreaming<UploadPartCopyRequest> {
    override fun serialize(context: ExecutionContext, input: UploadPartCopyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                input.key.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("x-id", "UploadPartCopy")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.partNumber != null) add("partNumber", input.partNumber.toString())
                if (input.uploadId != null) add("uploadId", input.uploadId)
            }
        }

        builder.headers {
            if (input.copySource?.isNotEmpty() == true) append("x-amz-copy-source", input.copySource)
            if (input.copySourceIfMatch?.isNotEmpty() == true) append("x-amz-copy-source-if-match", input.copySourceIfMatch)
            if (input.copySourceIfModifiedSince != null) append("x-amz-copy-source-if-modified-since", input.copySourceIfModifiedSince.format(TimestampFormat.RFC_5322))
            if (input.copySourceIfNoneMatch?.isNotEmpty() == true) append("x-amz-copy-source-if-none-match", input.copySourceIfNoneMatch)
            if (input.copySourceIfUnmodifiedSince != null) append("x-amz-copy-source-if-unmodified-since", input.copySourceIfUnmodifiedSince.format(TimestampFormat.RFC_5322))
            if (input.copySourceRange?.isNotEmpty() == true) append("x-amz-copy-source-range", input.copySourceRange)
            if (input.copySourceSseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-copy-source-server-side-encryption-customer-algorithm", input.copySourceSseCustomerAlgorithm)
            if (input.copySourceSseCustomerKey?.isNotEmpty() == true) append("x-amz-copy-source-server-side-encryption-customer-key", input.copySourceSseCustomerKey)
            if (input.copySourceSseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-copy-source-server-side-encryption-customer-key-MD5", input.copySourceSseCustomerKeyMd5)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.expectedSourceBucketOwner?.isNotEmpty() == true) append("x-amz-source-expected-bucket-owner", input.expectedSourceBucketOwner)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        return builder
    }
}
