// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.sdk.kotlin.services.s3.model.RestoreObjectRequest
import aws.sdk.kotlin.services.s3.model.RestoreRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class RestoreObjectOperationSerializer: HttpSerializer.NonStreaming<RestoreObjectRequest> {
    override fun serialize(context: ExecutionContext, input: RestoreObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                input.key.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("restore", "")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.versionId != null) add("versionId", input.versionId)
            }
        }

        builder.headers {
            if (input.checksumAlgorithm != null) append("x-amz-sdk-checksum-algorithm", input.checksumAlgorithm.value)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
        }

        if (input.restoreRequest != null) {
            val payload = serializeRestoreRequestPayloadWithXmlNameRestoreRequest(input.restoreRequest)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
