// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.AccessControlPolicy
import aws.sdk.kotlin.services.s3.model.BucketCannedAcl
import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.PutBucketAclRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutBucketAclOperationSerializer: HttpSerializer.NonStreaming<PutBucketAclRequest> {
    override fun serialize(context: ExecutionContext, input: PutBucketAclRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.trailingSlash = true
            parameters.decodedParameters {
                add("acl", "")
            }
        }

        builder.headers {
            if (input.acl != null) append("x-amz-acl", input.acl.value)
            if (input.checksumAlgorithm != null) append("x-amz-sdk-checksum-algorithm", input.checksumAlgorithm.value)
            if (input.contentMd5?.isNotEmpty() == true) append("Content-MD5", input.contentMd5)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.grantFullControl?.isNotEmpty() == true) append("x-amz-grant-full-control", input.grantFullControl)
            if (input.grantRead?.isNotEmpty() == true) append("x-amz-grant-read", input.grantRead)
            if (input.grantReadAcp?.isNotEmpty() == true) append("x-amz-grant-read-acp", input.grantReadAcp)
            if (input.grantWrite?.isNotEmpty() == true) append("x-amz-grant-write", input.grantWrite)
            if (input.grantWriteAcp?.isNotEmpty() == true) append("x-amz-grant-write-acp", input.grantWriteAcp)
        }

        if (input.accessControlPolicy != null) {
            val payload = serializeAccessControlPolicyPayloadWithXmlNameAccessControlPolicy(input.accessControlPolicy)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
