// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.MultipartUpload
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeMultipartUploadDocument(reader: XmlTagReader): MultipartUpload {
    val builder = MultipartUpload.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // UploadId com.amazonaws.s3#MultipartUpload$UploadId
            "UploadId" -> builder.uploadId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#MultipartUploadId`)" }
            // Key com.amazonaws.s3#MultipartUpload$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // Initiated com.amazonaws.s3#MultipartUpload$Initiated
            "Initiated" -> builder.initiated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3#Initiated`)" }
            // StorageClass com.amazonaws.s3#MultipartUpload$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            // Owner com.amazonaws.s3#MultipartUpload$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // Initiator com.amazonaws.s3#MultipartUpload$Initiator
            "Initiator" -> builder.initiator = deserializeInitiatorDocument(curr)
            // ChecksumAlgorithm com.amazonaws.s3#MultipartUpload$ChecksumAlgorithm
            "ChecksumAlgorithm" -> builder.checksumAlgorithm = curr.tryData()
                .parse { ChecksumAlgorithm.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ChecksumAlgorithm`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
