// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.Initiator
import aws.sdk.kotlin.services.s3.model.ListPartsResponse
import aws.sdk.kotlin.services.s3.model.Owner
import aws.sdk.kotlin.services.s3.model.Part
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant


internal class ListPartsOperationDeserializer: HttpDeserializer.NonStreaming<ListPartsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListPartsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListPartsError(context, call, payload)
        }
        val builder = ListPartsResponse.Builder()

        builder.abortDate = response.headers["x-amz-abort-date"]?.let { Instant.fromRfc5322(it) }
        builder.abortRuleId = response.headers["x-amz-abort-rule-id"]
        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }

        if (payload != null) {
            deserializeListPartsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListPartsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPartsOperationBody(builder: ListPartsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3#ListPartsOutput$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#BucketName`)" }
            // ChecksumAlgorithm com.amazonaws.s3#ListPartsOutput$ChecksumAlgorithm
            "ChecksumAlgorithm" -> builder.checksumAlgorithm = curr.tryData()
                .parse { ChecksumAlgorithm.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ChecksumAlgorithm`)" }
            // Initiator com.amazonaws.s3#ListPartsOutput$Initiator
            "Initiator" -> builder.initiator = deserializeInitiatorDocument(curr)
            // IsTruncated com.amazonaws.s3#ListPartsOutput$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // Key com.amazonaws.s3#ListPartsOutput$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // MaxParts com.amazonaws.s3#ListPartsOutput$MaxParts
            "MaxParts" -> builder.maxParts = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#MaxParts`)" }
            // NextPartNumberMarker com.amazonaws.s3#ListPartsOutput$NextPartNumberMarker
            "NextPartNumberMarker" -> builder.nextPartNumberMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextPartNumberMarker`)" }
            // Owner com.amazonaws.s3#ListPartsOutput$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // PartNumberMarker com.amazonaws.s3#ListPartsOutput$PartNumberMarker
            "PartNumberMarker" -> builder.partNumberMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#PartNumberMarker`)" }
            // Parts com.amazonaws.s3#ListPartsOutput$Parts
            "Part" -> builder.parts = run {
                val el = deserializePartDocument(curr)
                createOrAppend(builder.parts, el)
            }
            // StorageClass com.amazonaws.s3#ListPartsOutput$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            // UploadId com.amazonaws.s3#ListPartsOutput$UploadId
            "UploadId" -> builder.uploadId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#MultipartUploadId`)" }
            else -> {}
        }
        curr.drop()
    }
}
