// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.Bucket
import aws.sdk.kotlin.services.s3.model.ListBucketsResponse
import aws.sdk.kotlin.services.s3.model.Owner
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListBucketsOperationDeserializer: HttpDeserializer.NonStreaming<ListBucketsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListBucketsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListBucketsError(context, call, payload)
        }
        val builder = ListBucketsResponse.Builder()

        if (payload != null) {
            deserializeListBucketsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListBucketsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBucketsOperationBody(builder: ListBucketsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Buckets com.amazonaws.s3#ListBucketsOutput$Buckets
            "Buckets" -> builder.buckets = deserializeBucketsShape(curr)
            // ContinuationToken com.amazonaws.s3#ListBucketsOutput$ContinuationToken
            "ContinuationToken" -> builder.continuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextToken`)" }
            // Owner com.amazonaws.s3#ListBucketsOutput$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // Prefix com.amazonaws.s3#ListBucketsOutput$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Prefix`)" }
            else -> {}
        }
        curr.drop()
    }
}
