// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.ListBucketMetricsConfigurationsResponse
import aws.sdk.kotlin.services.s3.model.MetricsConfiguration
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListBucketMetricsConfigurationsOperationDeserializer: HttpDeserializer.NonStreaming<ListBucketMetricsConfigurationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListBucketMetricsConfigurationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListBucketMetricsConfigurationsError(context, call, payload)
        }
        val builder = ListBucketMetricsConfigurationsResponse.Builder()

        if (payload != null) {
            deserializeListBucketMetricsConfigurationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListBucketMetricsConfigurationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBucketMetricsConfigurationsOperationBody(builder: ListBucketMetricsConfigurationsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // ContinuationToken com.amazonaws.s3#ListBucketMetricsConfigurationsOutput$ContinuationToken
            "ContinuationToken" -> builder.continuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Token`)" }
            // IsTruncated com.amazonaws.s3#ListBucketMetricsConfigurationsOutput$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // MetricsConfigurationList com.amazonaws.s3#ListBucketMetricsConfigurationsOutput$MetricsConfigurationList
            "MetricsConfiguration" -> builder.metricsConfigurationList = run {
                val el = deserializeMetricsConfigurationDocument(curr)
                createOrAppend(builder.metricsConfigurationList, el)
            }
            // NextContinuationToken com.amazonaws.s3#ListBucketMetricsConfigurationsOutput$NextContinuationToken
            "NextContinuationToken" -> builder.nextContinuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextToken`)" }
            else -> {}
        }
        curr.drop()
    }
}
