// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.InventoryConfiguration
import aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsResponse
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListBucketInventoryConfigurationsOperationDeserializer: HttpDeserializer.NonStreaming<ListBucketInventoryConfigurationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListBucketInventoryConfigurationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListBucketInventoryConfigurationsError(context, call, payload)
        }
        val builder = ListBucketInventoryConfigurationsResponse.Builder()

        if (payload != null) {
            deserializeListBucketInventoryConfigurationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListBucketInventoryConfigurationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBucketInventoryConfigurationsOperationBody(builder: ListBucketInventoryConfigurationsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // ContinuationToken com.amazonaws.s3#ListBucketInventoryConfigurationsOutput$ContinuationToken
            "ContinuationToken" -> builder.continuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Token`)" }
            // InventoryConfigurationList com.amazonaws.s3#ListBucketInventoryConfigurationsOutput$InventoryConfigurationList
            "InventoryConfiguration" -> builder.inventoryConfigurationList = run {
                val el = deserializeInventoryConfigurationDocument(curr)
                createOrAppend(builder.inventoryConfigurationList, el)
            }
            // IsTruncated com.amazonaws.s3#ListBucketInventoryConfigurationsOutput$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // NextContinuationToken com.amazonaws.s3#ListBucketInventoryConfigurationsOutput$NextContinuationToken
            "NextContinuationToken" -> builder.nextContinuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextToken`)" }
            else -> {}
        }
        curr.drop()
    }
}
