// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.IntelligentTieringAccessTier
import aws.sdk.kotlin.services.s3.model.InvalidObjectState
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class InvalidObjectStateDeserializer: HttpDeserializer.NonStreaming<InvalidObjectState> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): InvalidObjectState {
        val response = call.response
        val builder = InvalidObjectState.Builder()

        if (payload != null) {
            deserializeInvalidObjectStateError(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

internal fun deserializeInvalidObjectStateError(builder: InvalidObjectState.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val errReader = unwrapXmlErrorResponse(root)

    loop@while (true) {
        val curr = errReader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessTier com.amazonaws.s3#InvalidObjectState$AccessTier
            "AccessTier" -> builder.accessTier = curr.tryData()
                .parse { IntelligentTieringAccessTier.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#IntelligentTieringAccessTier`)" }
            // StorageClass com.amazonaws.s3#InvalidObjectState$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            else -> {}
        }
        curr.drop()
    }
}
