// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.GetObjectAttributesRequest
import aws.sdk.kotlin.services.s3.model.ObjectAttributes
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.quoteHeaderValue
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class GetObjectAttributesOperationSerializer: HttpSerializer.NonStreaming<GetObjectAttributesRequest> {
    override fun serialize(context: ExecutionContext, input: GetObjectAttributesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                input.key.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("attributes", "")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.versionId != null) add("versionId", input.versionId)
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.maxParts != null) append("x-amz-max-parts", input.maxParts.toString())
            if (input.objectAttributes?.isNotEmpty() == true) appendAll("x-amz-object-attributes", input.objectAttributes.map { quoteHeaderValue(it.value) })
            if (input.partNumberMarker?.isNotEmpty() == true) append("x-amz-part-number-marker", input.partNumberMarker)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        return builder
    }
}
