// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.Checksum
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant


internal class GetObjectAttributesOperationDeserializer: HttpDeserializer.NonStreaming<GetObjectAttributesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetObjectAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetObjectAttributesError(context, call, payload)
        }
        val builder = GetObjectAttributesResponse.Builder()

        builder.deleteMarker = response.headers["x-amz-delete-marker"]?.toBoolean()
        builder.lastModified = response.headers["Last-Modified"]?.let { Instant.fromRfc5322(it) }
        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }
        builder.versionId = response.headers["x-amz-version-id"]

        if (payload != null) {
            deserializeGetObjectAttributesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetObjectAttributesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        "NoSuchKey" -> NoSuchKeyDeserializer().deserialize(context, wrappedCall, payload)
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetObjectAttributesOperationBody(builder: GetObjectAttributesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Checksum com.amazonaws.s3#GetObjectAttributesOutput$Checksum
            "Checksum" -> builder.checksum = deserializeChecksumDocument(curr)
            // ETag com.amazonaws.s3#GetObjectAttributesOutput$ETag
            "ETag" -> builder.eTag = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ETag`)" }
            // ObjectParts com.amazonaws.s3#GetObjectAttributesOutput$ObjectParts
            "ObjectParts" -> builder.objectParts = deserializeGetObjectAttributesPartsDocument(curr)
            // ObjectSize com.amazonaws.s3#GetObjectAttributesOutput$ObjectSize
            "ObjectSize" -> builder.objectSize = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3#ObjectSize`)" }
            // StorageClass com.amazonaws.s3#GetObjectAttributesOutput$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            else -> {}
        }
        curr.drop()
    }
}
