// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.ErrorDocument
import aws.sdk.kotlin.services.s3.model.GetBucketWebsiteResponse
import aws.sdk.kotlin.services.s3.model.IndexDocument
import aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo
import aws.sdk.kotlin.services.s3.model.RoutingRule
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetBucketWebsiteOperationDeserializer: HttpDeserializer.NonStreaming<GetBucketWebsiteResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBucketWebsiteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBucketWebsiteError(context, call, payload)
        }
        val builder = GetBucketWebsiteResponse.Builder()

        if (payload != null) {
            deserializeGetBucketWebsiteOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBucketWebsiteError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketWebsiteOperationBody(builder: GetBucketWebsiteResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // ErrorDocument com.amazonaws.s3#GetBucketWebsiteOutput$ErrorDocument
            "ErrorDocument" -> builder.errorDocument = deserializeErrorDocumentDocument(curr)
            // IndexDocument com.amazonaws.s3#GetBucketWebsiteOutput$IndexDocument
            "IndexDocument" -> builder.indexDocument = deserializeIndexDocumentDocument(curr)
            // RedirectAllRequestsTo com.amazonaws.s3#GetBucketWebsiteOutput$RedirectAllRequestsTo
            "RedirectAllRequestsTo" -> builder.redirectAllRequestsTo = deserializeRedirectAllRequestsToDocument(curr)
            // RoutingRules com.amazonaws.s3#GetBucketWebsiteOutput$RoutingRules
            "RoutingRules" -> builder.routingRules = deserializeRoutingRulesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
