// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.GetBucketTaggingResponse
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetBucketTaggingOperationDeserializer: HttpDeserializer.NonStreaming<GetBucketTaggingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBucketTaggingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBucketTaggingError(context, call, payload)
        }
        val builder = GetBucketTaggingResponse.Builder()

        if (payload != null) {
            deserializeGetBucketTaggingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBucketTaggingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketTaggingOperationBody(builder: GetBucketTaggingResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // TagSet com.amazonaws.s3#GetBucketTaggingOutput$TagSet
            "TagSet" -> builder.tagSet = deserializeTagSetShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
