// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.EventBridgeConfiguration
import aws.sdk.kotlin.services.s3.model.GetBucketNotificationConfigurationResponse
import aws.sdk.kotlin.services.s3.model.LambdaFunctionConfiguration
import aws.sdk.kotlin.services.s3.model.QueueConfiguration
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.TopicConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetBucketNotificationConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<GetBucketNotificationConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBucketNotificationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBucketNotificationConfigurationError(context, call, payload)
        }
        val builder = GetBucketNotificationConfigurationResponse.Builder()

        if (payload != null) {
            deserializeGetBucketNotificationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBucketNotificationConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketNotificationConfigurationOperationBody(builder: GetBucketNotificationConfigurationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventBridgeConfiguration com.amazonaws.s3#NotificationConfiguration$EventBridgeConfiguration
            "EventBridgeConfiguration" -> builder.eventBridgeConfiguration = deserializeEventBridgeConfigurationDocument(curr)
            // LambdaFunctionConfigurations com.amazonaws.s3#NotificationConfiguration$LambdaFunctionConfigurations
            "CloudFunctionConfiguration" -> builder.lambdaFunctionConfigurations = run {
                val el = deserializeLambdaFunctionConfigurationDocument(curr)
                createOrAppend(builder.lambdaFunctionConfigurations, el)
            }
            // QueueConfigurations com.amazonaws.s3#NotificationConfiguration$QueueConfigurations
            "QueueConfiguration" -> builder.queueConfigurations = run {
                val el = deserializeQueueConfigurationDocument(curr)
                createOrAppend(builder.queueConfigurations, el)
            }
            // TopicConfigurations com.amazonaws.s3#NotificationConfiguration$TopicConfigurations
            "TopicConfiguration" -> builder.topicConfigurations = run {
                val el = deserializeTopicConfigurationDocument(curr)
                createOrAppend(builder.topicConfigurations, el)
            }
            else -> {}
        }
        curr.drop()
    }
}
