// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.DeleteObjectRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DeleteObjectOperationSerializer: HttpSerializer.NonStreaming<DeleteObjectRequest> {
    override fun serialize(context: ExecutionContext, input: DeleteObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.DELETE

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                input.key.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("x-id", "DeleteObject")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.versionId != null) add("versionId", input.versionId)
            }
        }

        builder.headers {
            if (input.bypassGovernanceRetention != null) append("x-amz-bypass-governance-retention", input.bypassGovernanceRetention.toString())
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
            if (input.ifMatchLastModifiedTime != null) append("x-amz-if-match-last-modified-time", input.ifMatchLastModifiedTime.format(TimestampFormat.RFC_5322))
            if (input.ifMatchSize != null) append("x-amz-if-match-size", input.ifMatchSize.toString())
            if (input.mfa?.isNotEmpty() == true) append("x-amz-mfa", input.mfa)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
        }

        return builder
    }
}
