// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.CompleteMultipartUploadRequest
import aws.sdk.kotlin.services.s3.model.CompletedMultipartUpload
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CompleteMultipartUploadOperationSerializer: HttpSerializer.NonStreaming<CompleteMultipartUploadRequest> {
    override fun serialize(context: ExecutionContext, input: CompleteMultipartUploadRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                input.key.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.uploadId != null) add("uploadId", input.uploadId)
            }
        }

        builder.headers {
            if (input.checksumCrc32?.isNotEmpty() == true) append("x-amz-checksum-crc32", input.checksumCrc32)
            if (input.checksumCrc32C?.isNotEmpty() == true) append("x-amz-checksum-crc32c", input.checksumCrc32C)
            if (input.checksumSha1?.isNotEmpty() == true) append("x-amz-checksum-sha1", input.checksumSha1)
            if (input.checksumSha256?.isNotEmpty() == true) append("x-amz-checksum-sha256", input.checksumSha256)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
            if (input.ifNoneMatch?.isNotEmpty() == true) append("If-None-Match", input.ifNoneMatch)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        if (input.multipartUpload != null) {
            val payload = serializeCompletedMultipartUploadPayloadWithXmlNameCompleteMultipartUpload(input.multipartUpload)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
