// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.CompleteMultipartUploadResponse
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.ServerSideEncryption
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CompleteMultipartUploadOperationDeserializer: HttpDeserializer.NonStreaming<CompleteMultipartUploadResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CompleteMultipartUploadResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCompleteMultipartUploadError(context, call, payload)
        }
        val builder = CompleteMultipartUploadResponse.Builder()

        builder.bucketKeyEnabled = response.headers["x-amz-server-side-encryption-bucket-key-enabled"]?.toBoolean()
        builder.expiration = response.headers["x-amz-expiration"]
        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }
        builder.ssekmsKeyId = response.headers["x-amz-server-side-encryption-aws-kms-key-id"]
        builder.serverSideEncryption = response.headers["x-amz-server-side-encryption"]?.let { ServerSideEncryption.fromValue(it) }
        builder.versionId = response.headers["x-amz-version-id"]

        if (payload != null) {
            deserializeCompleteMultipartUploadOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCompleteMultipartUploadError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null) {
            if (call.response.status == HttpStatusCode.NotFound) {
                S3ErrorDetails(code = "NotFound")

            } else {
                S3ErrorDetails(code = call.response.status.toString())

            }
        } else {
            parseS3ErrorResponse(payload)

        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as restXml error").also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }
    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCompleteMultipartUploadOperationBody(builder: CompleteMultipartUploadResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3#CompleteMultipartUploadOutput$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#BucketName`)" }
            // ChecksumCRC32 com.amazonaws.s3#CompleteMultipartUploadOutput$ChecksumCRC32
            "ChecksumCRC32" -> builder.checksumCrc32 = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ChecksumCRC32`)" }
            // ChecksumCRC32C com.amazonaws.s3#CompleteMultipartUploadOutput$ChecksumCRC32C
            "ChecksumCRC32C" -> builder.checksumCrc32C = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ChecksumCRC32C`)" }
            // ChecksumSHA1 com.amazonaws.s3#CompleteMultipartUploadOutput$ChecksumSHA1
            "ChecksumSHA1" -> builder.checksumSha1 = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ChecksumSHA1`)" }
            // ChecksumSHA256 com.amazonaws.s3#CompleteMultipartUploadOutput$ChecksumSHA256
            "ChecksumSHA256" -> builder.checksumSha256 = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ChecksumSHA256`)" }
            // ETag com.amazonaws.s3#CompleteMultipartUploadOutput$ETag
            "ETag" -> builder.eTag = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ETag`)" }
            // Key com.amazonaws.s3#CompleteMultipartUploadOutput$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // Location com.amazonaws.s3#CompleteMultipartUploadOutput$Location
            "Location" -> builder.location = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Location`)" }
            else -> {}
        }
        curr.drop()
    }
}
