// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.paginators

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.model.Bucket
import aws.sdk.kotlin.services.s3.model.ListBucketsRequest
import aws.sdk.kotlin.services.s3.model.ListBucketsResponse
import aws.sdk.kotlin.services.s3.model.ListDirectoryBucketsRequest
import aws.sdk.kotlin.services.s3.model.ListDirectoryBucketsResponse
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Request
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Response
import aws.sdk.kotlin.services.s3.model.ListPartsRequest
import aws.sdk.kotlin.services.s3.model.ListPartsResponse
import aws.sdk.kotlin.services.s3.model.Part
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBucketsResponse]
 */
public fun S3Client.listBucketsPaginated(initialRequest: ListBucketsRequest = ListBucketsRequest { }): Flow<ListBucketsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.continuationToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.continuationToken = cursor
            }
            val result = this@listBucketsPaginated.listBuckets(req)
            cursor = result.continuationToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBucketsResponse]
 */
public fun S3Client.listBucketsPaginated(block: ListBucketsRequest.Builder.() -> Unit): Flow<ListBucketsResponse> =
    listBucketsPaginated(ListBucketsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBucketsPaginated]
 * to access the nested member [Bucket]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Bucket]
 */
@JvmName("listBucketsResponseBucket")
public fun Flow<ListBucketsResponse>.buckets(): Flow<Bucket> =
    transform() { response ->
        response.buckets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDirectoryBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDirectoryBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDirectoryBucketsResponse]
 */
public fun S3Client.listDirectoryBucketsPaginated(initialRequest: ListDirectoryBucketsRequest = ListDirectoryBucketsRequest { }): Flow<ListDirectoryBucketsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.continuationToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.continuationToken = cursor
            }
            val result = this@listDirectoryBucketsPaginated.listDirectoryBuckets(req)
            cursor = result.continuationToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDirectoryBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDirectoryBucketsResponse]
 */
public fun S3Client.listDirectoryBucketsPaginated(block: ListDirectoryBucketsRequest.Builder.() -> Unit): Flow<ListDirectoryBucketsResponse> =
    listDirectoryBucketsPaginated(ListDirectoryBucketsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDirectoryBucketsPaginated]
 * to access the nested member [Bucket]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Bucket]
 */
@JvmName("listDirectoryBucketsResponseBucket")
public fun Flow<ListDirectoryBucketsResponse>.buckets(): Flow<Bucket> =
    transform() { response ->
        response.buckets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListObjectsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObjectsV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsV2Response]
 */
public fun S3Client.listObjectsV2Paginated(initialRequest: ListObjectsV2Request): Flow<ListObjectsV2Response> =
    flow {
        var cursor: kotlin.String? = initialRequest.continuationToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.continuationToken = cursor
            }
            val result = this@listObjectsV2Paginated.listObjectsV2(req)
            cursor = result.nextContinuationToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListObjectsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsV2Response]
 */
public fun S3Client.listObjectsV2Paginated(block: ListObjectsV2Request.Builder.() -> Unit): Flow<ListObjectsV2Response> =
    listObjectsV2Paginated(ListObjectsV2Request.Builder().apply(block).build())

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPartsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
public fun S3Client.listPartsPaginated(initialRequest: ListPartsRequest): Flow<ListPartsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.partNumberMarker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.partNumberMarker = cursor
            }
            val result = this@listPartsPaginated.listParts(req)
            cursor = result.nextPartNumberMarker
            hasNextPage = result.isTruncated == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
public fun S3Client.listPartsPaginated(block: ListPartsRequest.Builder.() -> Unit): Flow<ListPartsResponse> =
    listPartsPaginated(ListPartsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPartsPaginated]
 * to access the nested member [Part]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Part]
 */
@JvmName("listPartsResponsePart")
public fun Flow<ListPartsResponse>.parts(): Flow<Part> =
    transform() { response ->
        response.parts?.forEach {
            emit(it)
        }
    }
