// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see [Transitioning Objects Using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html) in the *Amazon S3 User Guide*.
 */
public class Transition private constructor(builder: Builder) {
    /**
     * Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.
     */
    public val days: kotlin.Int? = builder.days
    /**
     * The storage class to which you want the object to transition.
     */
    public val storageClass: aws.sdk.kotlin.services.s3.model.TransitionStorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Transition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Transition(")
        append("date=$date,")
        append("days=$days,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = date?.hashCode() ?: 0
        result = 31 * result + (days ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Transition

        if (date != other.date) return false
        if (days != other.days) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Transition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.
         */
        public var days: kotlin.Int? = null
        /**
         * The storage class to which you want the object to transition.
         */
        public var storageClass: aws.sdk.kotlin.services.s3.model.TransitionStorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Transition) : this() {
            this.date = x.date
            this.days = x.days
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Transition = Transition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
