// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without additional operational overhead.
 */
public class Tiering private constructor(builder: Builder) {
    /**
     * S3 Intelligent-Tiering access tier. See [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access) for a list of access tiers in the S3 Intelligent-Tiering storage class.
     */
    public val accessTier: aws.sdk.kotlin.services.s3.model.IntelligentTieringAccessTier = requireNotNull(builder.accessTier) { "A non-null value must be provided for accessTier" }
    /**
     * The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
     */
    public val days: kotlin.Int = requireNotNull(builder.days) { "A non-null value must be provided for days" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Tiering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tiering(")
        append("accessTier=$accessTier,")
        append("days=$days")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTier.hashCode()
        result = 31 * result + (days)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tiering

        if (accessTier != other.accessTier) return false
        if (days != other.days) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Tiering = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * S3 Intelligent-Tiering access tier. See [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access) for a list of access tiers in the S3 Intelligent-Tiering storage class.
         */
        public var accessTier: aws.sdk.kotlin.services.s3.model.IntelligentTieringAccessTier? = null
        /**
         * The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
         */
        public var days: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Tiering) : this() {
            this.accessTier = x.accessTier
            this.days = x.days
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Tiering = Tiering(this)

        internal fun correctErrors(): Builder {
            if (accessTier == null) accessTier = IntelligentTieringAccessTier.SdkUnknown("no value provided")
            if (days == null) days = 0
            return this
        }
    }
}
