// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for data related to the storage class analysis for an Amazon S3 bucket for export.
 */
public class StorageClassAnalysisDataExport private constructor(builder: Builder) {
    /**
     * The place to store the data for an analysis.
     */
    public val destination: aws.sdk.kotlin.services.s3.model.AnalyticsExportDestination? = builder.destination
    /**
     * The version of the output schema to use when exporting data. Must be `V_1`.
     */
    public val outputSchemaVersion: aws.sdk.kotlin.services.s3.model.StorageClassAnalysisSchemaVersion = requireNotNull(builder.outputSchemaVersion) { "A non-null value must be provided for outputSchemaVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.StorageClassAnalysisDataExport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageClassAnalysisDataExport(")
        append("destination=$destination,")
        append("outputSchemaVersion=$outputSchemaVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (outputSchemaVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageClassAnalysisDataExport

        if (destination != other.destination) return false
        if (outputSchemaVersion != other.outputSchemaVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.StorageClassAnalysisDataExport = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The place to store the data for an analysis.
         */
        public var destination: aws.sdk.kotlin.services.s3.model.AnalyticsExportDestination? = null
        /**
         * The version of the output schema to use when exporting data. Must be `V_1`.
         */
        public var outputSchemaVersion: aws.sdk.kotlin.services.s3.model.StorageClassAnalysisSchemaVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.StorageClassAnalysisDataExport) : this() {
            this.destination = x.destination
            this.outputSchemaVersion = x.outputSchemaVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.StorageClassAnalysisDataExport = StorageClassAnalysisDataExport(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.AnalyticsExportDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.s3.model.AnalyticsExportDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.s3.model.AnalyticsExportDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (outputSchemaVersion == null) outputSchemaVersion = StorageClassAnalysisSchemaVersion.SdkUnknown("no value provided")
            return this
        }
    }
}
