// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the default server-side encryption configuration.
 *
 * + **General purpose buckets** - If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
 * + **Directory buckets** - When you specify an [KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) for encryption in your directory bucket, only use the key ID or key ARN. The key alias format of the KMS key isn't supported.
 */
public class ServerSideEncryptionRule private constructor(builder: Builder) {
    /**
     * Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
     */
    public val applyServerSideEncryptionByDefault: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault? = builder.applyServerSideEncryptionByDefault
    /**
     * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the `BucketKeyEnabled` element to `true` causes Amazon S3 to use an S3 Bucket Key.
     *
     * + **General purpose buckets** - By default, S3 Bucket Key is not enabled. For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
     * + **Directory buckets** - S3 Bucket Keys are always enabled for `GET` and `PUT` operations in a directory bucket and can’t be disabled. S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through [CopyObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html), [UploadPartCopy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html), [the Copy operation in Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops), or [the import jobs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job). In this case, Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
     */
    public val bucketKeyEnabled: kotlin.Boolean? = builder.bucketKeyEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryptionRule(")
        append("applyServerSideEncryptionByDefault=$applyServerSideEncryptionByDefault,")
        append("bucketKeyEnabled=$bucketKeyEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyServerSideEncryptionByDefault?.hashCode() ?: 0
        result = 31 * result + (bucketKeyEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerSideEncryptionRule

        if (applyServerSideEncryptionByDefault != other.applyServerSideEncryptionByDefault) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
         */
        public var applyServerSideEncryptionByDefault: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault? = null
        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the `BucketKeyEnabled` element to `true` causes Amazon S3 to use an S3 Bucket Key.
         *
         * + **General purpose buckets** - By default, S3 Bucket Key is not enabled. For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
         * + **Directory buckets** - S3 Bucket Keys are always enabled for `GET` and `PUT` operations in a directory bucket and can’t be disabled. S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through [CopyObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html), [UploadPartCopy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html), [the Copy operation in Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops), or [the import jobs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job). In this case, Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
         */
        public var bucketKeyEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule) : this() {
            this.applyServerSideEncryptionByDefault = x.applyServerSideEncryptionByDefault
            this.bucketKeyEnabled = x.bucketKeyEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = ServerSideEncryptionRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault] inside the given [block]
         */
        public fun applyServerSideEncryptionByDefault(block: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault.Builder.() -> kotlin.Unit) {
            this.applyServerSideEncryptionByDefault = aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
