// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.
 */
public class ScanRange private constructor(builder: Builder) {
    /**
     * Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, `<scanrange><end>50</end></scanrange>` means scan the last 50 bytes.
     */
    public val end: kotlin.Long? = builder.end
    /**
     * Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only `start` is supplied, it means scan from that point to the end of the file. For example, `<scanrange><start>50</start></scanrange>` means scan from byte 50 until the end of the file.
     */
    public val start: kotlin.Long? = builder.start

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ScanRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScanRange(")
        append("end=$end,")
        append("start=$start")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = end?.hashCode() ?: 0
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScanRange

        if (end != other.end) return false
        if (start != other.start) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ScanRange = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, `<scanrange><end>50</end></scanrange>` means scan the last 50 bytes.
         */
        public var end: kotlin.Long? = null
        /**
         * Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only `start` is supplied, it means scan from that point to the end of the file. For example, `<scanrange><start>50</start></scanrange>` means scan from byte 50 until the end of the file.
         */
        public var start: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ScanRange) : this() {
            this.end = x.end
            this.start = x.start
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ScanRange = ScanRange(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
