// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the `aws_s3_metadata` namespace in the destination table bucket.
 */
public class S3TablesDestinationResult private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the `aws_s3_metadata` namespace in the destination table bucket.
     */
    public val tableArn: kotlin.String = requireNotNull(builder.tableArn) { "A non-null value must be provided for tableArn" }
    /**
     * The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.
     */
    public val tableBucketArn: kotlin.String = requireNotNull(builder.tableBucketArn) { "A non-null value must be provided for tableBucketArn" }
    /**
     * The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the `aws_s3_metadata` namespace in the destination table bucket.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }
    /**
     * The table bucket namespace for the metadata table in your metadata table configuration. This value is always `aws_s3_metadata`.
     */
    public val tableNamespace: kotlin.String = requireNotNull(builder.tableNamespace) { "A non-null value must be provided for tableNamespace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.S3TablesDestinationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3TablesDestinationResult(")
        append("tableArn=$tableArn,")
        append("tableBucketArn=$tableBucketArn,")
        append("tableName=$tableName,")
        append("tableNamespace=$tableNamespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tableArn.hashCode()
        result = 31 * result + (tableBucketArn.hashCode())
        result = 31 * result + (tableName.hashCode())
        result = 31 * result + (tableNamespace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3TablesDestinationResult

        if (tableArn != other.tableArn) return false
        if (tableBucketArn != other.tableBucketArn) return false
        if (tableName != other.tableName) return false
        if (tableNamespace != other.tableNamespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.S3TablesDestinationResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the `aws_s3_metadata` namespace in the destination table bucket.
         */
        public var tableArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.
         */
        public var tableBucketArn: kotlin.String? = null
        /**
         * The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the `aws_s3_metadata` namespace in the destination table bucket.
         */
        public var tableName: kotlin.String? = null
        /**
         * The table bucket namespace for the metadata table in your metadata table configuration. This value is always `aws_s3_metadata`.
         */
        public var tableNamespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.S3TablesDestinationResult) : this() {
            this.tableArn = x.tableArn
            this.tableBucketArn = x.tableBucketArn
            this.tableName = x.tableName
            this.tableNamespace = x.tableNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.S3TablesDestinationResult = S3TablesDestinationResult(this)

        internal fun correctErrors(): Builder {
            if (tableArn == null) tableArn = ""
            if (tableBucketArn == null) tableBucketArn = ""
            if (tableName == null) tableName = ""
            if (tableNamespace == null) tableNamespace = ""
            return this
        }
    }
}
