// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see [ Working with archived objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html) in the *Amazon S3 User Guide*.
 *
 * This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
 */
public class RestoreStatus private constructor(builder: Builder) {
    /**
     * Specifies whether the object is currently being restored. If the object restoration is in progress, the header returns the value `TRUE`. For example:
     *
     * `x-amz-optional-object-attributes: IsRestoreInProgress="true"`
     *
     * If the object restoration has completed, the header returns the value `FALSE`. For example:
     *
     * `x-amz-optional-object-attributes: IsRestoreInProgress="false", RestoreExpiryDate="2012-12-21T00:00:00.000Z"`
     *
     * If the object hasn't been restored, there is no header response.
     */
    public val isRestoreInProgress: kotlin.Boolean? = builder.isRestoreInProgress
    /**
     * Indicates when the restored copy will expire. This value is populated only if the object has already been restored. For example:
     *
     * `x-amz-optional-object-attributes: IsRestoreInProgress="false", RestoreExpiryDate="2012-12-21T00:00:00.000Z"`
     */
    public val restoreExpiryDate: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreExpiryDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.RestoreStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreStatus(")
        append("isRestoreInProgress=$isRestoreInProgress,")
        append("restoreExpiryDate=$restoreExpiryDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isRestoreInProgress?.hashCode() ?: 0
        result = 31 * result + (restoreExpiryDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreStatus

        if (isRestoreInProgress != other.isRestoreInProgress) return false
        if (restoreExpiryDate != other.restoreExpiryDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.RestoreStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the object is currently being restored. If the object restoration is in progress, the header returns the value `TRUE`. For example:
         *
         * `x-amz-optional-object-attributes: IsRestoreInProgress="true"`
         *
         * If the object restoration has completed, the header returns the value `FALSE`. For example:
         *
         * `x-amz-optional-object-attributes: IsRestoreInProgress="false", RestoreExpiryDate="2012-12-21T00:00:00.000Z"`
         *
         * If the object hasn't been restored, there is no header response.
         */
        public var isRestoreInProgress: kotlin.Boolean? = null
        /**
         * Indicates when the restored copy will expire. This value is populated only if the object has already been restored. For example:
         *
         * `x-amz-optional-object-attributes: IsRestoreInProgress="false", RestoreExpiryDate="2012-12-21T00:00:00.000Z"`
         */
        public var restoreExpiryDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.RestoreStatus) : this() {
            this.isRestoreInProgress = x.isRestoreInProgress
            this.restoreExpiryDate = x.restoreExpiryDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.RestoreStatus = RestoreStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
