// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RestoreObjectRequest private constructor(builder: Builder) {
    /**
     * The bucket name containing the object to restore.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     *
     * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Object key for which the action was initiated.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Container for restore job parameters.
     */
    public val restoreRequest: aws.sdk.kotlin.services.s3.model.RestoreRequest? = builder.restoreRequest
    /**
     * VersionId used to reference a specific version of the object.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.RestoreObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreObjectRequest(")
        append("bucket=$bucket,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("key=$key,")
        append("requestPayer=$requestPayer,")
        append("restoreRequest=$restoreRequest,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (restoreRequest?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreObjectRequest

        if (bucket != other.bucket) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (key != other.key) return false
        if (requestPayer != other.requestPayer) return false
        if (restoreRequest != other.restoreRequest) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.RestoreObjectRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The bucket name containing the object to restore.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         *
         * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * Object key for which the action was initiated.
         */
        public var key: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Container for restore job parameters.
         */
        public var restoreRequest: aws.sdk.kotlin.services.s3.model.RestoreRequest? = null
        /**
         * VersionId used to reference a specific version of the object.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.RestoreObjectRequest) : this() {
            this.bucket = x.bucket
            this.checksumAlgorithm = x.checksumAlgorithm
            this.expectedBucketOwner = x.expectedBucketOwner
            this.key = x.key
            this.requestPayer = x.requestPayer
            this.restoreRequest = x.restoreRequest
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.RestoreObjectRequest = RestoreObjectRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.RestoreRequest] inside the given [block]
         */
        public fun restoreRequest(block: aws.sdk.kotlin.services.s3.model.RestoreRequest.Builder.() -> kotlin.Unit) {
            this.restoreRequest = aws.sdk.kotlin.services.s3.model.RestoreRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
