// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter.
 *
 * For example:
 * + If you specify both a `Prefix` and a `Tag` filter, wrap these filters in an `And` tag.
 * + If you specify a filter based on multiple tags, wrap the `Tag` elements in an `And` tag.
 */
public class ReplicationRuleAndOperator private constructor(builder: Builder) {
    /**
     * An object key name prefix that identifies the subset of objects to which the rule applies.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * An array of tags containing key and value pairs.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationRuleAndOperator(")
        append("prefix=$prefix,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = prefix?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationRuleAndOperator

        if (prefix != other.prefix) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object key name prefix that identifies the subset of objects to which the rule applies.
         */
        public var prefix: kotlin.String? = null
        /**
         * An array of tags containing key and value pairs.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator) : this() {
            this.prefix = x.prefix
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator = ReplicationRuleAndOperator(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
