// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the records event.
 */
public class RecordsEvent private constructor(builder: Builder) {
    /**
     * The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a `ByteStream` out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.
     */
    public val payload: kotlin.ByteArray? = builder.payload

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.RecordsEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordsEvent(")
        append("payload=$payload")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = payload?.contentHashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordsEvent

        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.RecordsEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a `ByteStream` out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.
         */
        public var payload: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.RecordsEvent) : this() {
            this.payload = x.payload
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.RecordsEvent = RecordsEvent(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
